-- ================================================================================
-- Migration Script: Packagemaker → fixed_v2
-- البيانات التشغيلية الأساسية فقط (بدون limits و message_templates)
-- ================================================================================
-- تاريخ الإنشاء: 2025-10-26
-- الهدف: ترحيل آمن idempotent للبيانات الضرورية
-- ================================================================================

SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO';

START TRANSACTION;

-- ================================================================================
-- 1. ترحيل sub_bots (26 بوت)
-- ================================================================================
-- ملاحظة: لن نرحل daily_attempts (معطّل في النظام الجديد)

INSERT INTO `supehgku_fixed_v2`.`sub_bots` 
  (`id`, `label`, `bot_token`, `channel_id`, `max_users`, `welcome_message`, 
   `is_paused`, `created_at`, `updated_at`)
SELECT 
  `id`, `label`, `bot_token`, `channel_id`, `max_users`, `welcome_message`,
  `is_paused`, `created_at`, `updated_at`
FROM `supehgku_Packagemaker`.`sub_bots`
ON DUPLICATE KEY UPDATE
  `label` = VALUES(`label`),
  `bot_token` = VALUES(`bot_token`),
  `channel_id` = VALUES(`channel_id`),
  `max_users` = VALUES(`max_users`),
  `welcome_message` = VALUES(`welcome_message`),
  `is_paused` = VALUES(`is_paused`),
  `updated_at` = VALUES(`updated_at`);

SELECT '✅ sub_bots migrated' AS status, 
       ROW_COUNT() AS affected_rows,
       (SELECT COUNT(*) FROM `supehgku_fixed_v2`.`sub_bots`) AS total_in_target;

-- ================================================================================
-- 2. ترحيل steam_accounts (102 حساب)
-- ================================================================================
-- ملاحظة: لن نرحل daily_attempts_override (معطّل في النظام الجديد)

INSERT INTO `supehgku_fixed_v2`.`steam_accounts`
  (`id`, `account_name`, `shared_secret`, `active`, `created_at`, `updated_at`)
SELECT
  `id`, `account_name`, `shared_secret`, `active`, `created_at`, `updated_at`
FROM `supehgku_Packagemaker`.`steam_accounts`
ON DUPLICATE KEY UPDATE
  `account_name` = VALUES(`account_name`),
  `shared_secret` = VALUES(`shared_secret`),
  `active` = VALUES(`active`),
  `updated_at` = VALUES(`updated_at`);

SELECT '✅ steam_accounts migrated' AS status,
       ROW_COUNT() AS affected_rows,
       (SELECT COUNT(*) FROM `supehgku_fixed_v2`.`steam_accounts`) AS total_in_target;

-- ================================================================================
-- 3. ترحيل allowed_users (358 مستخدم)
-- ================================================================================

INSERT INTO `supehgku_fixed_v2`.`allowed_users`
  (`id`, `bot_token`, `user_id`, `banned`, `created_at`)
SELECT
  `id`, `bot_token`, `user_id`, `banned`, `created_at`
FROM `supehgku_Packagemaker`.`allowed_users`
ON DUPLICATE KEY UPDATE
  `banned` = VALUES(`banned`),
  `created_at` = VALUES(`created_at`);

SELECT '✅ allowed_users migrated' AS status,
       ROW_COUNT() AS affected_rows,
       (SELECT COUNT(*) FROM `supehgku_fixed_v2`.`allowed_users`) AS total_in_target;

-- ================================================================================
-- 4. ترحيل steam_requests (3411 طلب)
-- ================================================================================

INSERT INTO `supehgku_fixed_v2`.`steam_requests`
  (`id`, `bot_token`, `user_id`, `account_name`, `request_time`)
SELECT
  `id`, `bot_token`, `user_id`, `account_name`, `request_time`
FROM `supehgku_Packagemaker`.`steam_requests`
ON DUPLICATE KEY UPDATE
  `bot_token` = VALUES(`bot_token`),
  `user_id` = VALUES(`user_id`),
  `account_name` = VALUES(`account_name`),
  `request_time` = VALUES(`request_time`);

SELECT '✅ steam_requests migrated' AS status,
       ROW_COUNT() AS affected_rows,
       (SELECT COUNT(*) FROM `supehgku_fixed_v2`.`steam_requests`) AS total_in_target;

-- ================================================================================
-- 5. [اختياري] ترحيل control_sessions (25 جلسة)
-- ================================================================================
-- قم بإلغاء التعليق إذا كنت تريد ترحيل جلسات التحكم القديمة

/*
INSERT INTO `supehgku_fixed_v2`.`control_sessions`
  (`id`, `user_id`, `action`, `bot_token`, `created_at`)
SELECT
  `id`, `user_id`, `action`, `bot_token`, `created_at`
FROM `supehgku_Packagemaker`.`control_sessions`
ON DUPLICATE KEY UPDATE
  `user_id` = VALUES(`user_id`),
  `action` = VALUES(`action`),
  `bot_token` = VALUES(`bot_token`),
  `created_at` = VALUES(`created_at`);

SELECT '✅ control_sessions migrated' AS status,
       ROW_COUNT() AS affected_rows,
       (SELECT COUNT(*) FROM `supehgku_fixed_v2`.`control_sessions`) AS total_in_target;
*/

-- ================================================================================
-- 6. التحقق النهائي (Verification)
-- ================================================================================

SELECT '📊 Migration Summary' AS '═══════════════════════════════════════';

SELECT 'sub_bots' AS table_name,
       (SELECT COUNT(*) FROM `supehgku_Packagemaker`.`sub_bots`) AS source_count,
       (SELECT COUNT(*) FROM `supehgku_fixed_v2`.`sub_bots`) AS target_count,
       CASE
         WHEN (SELECT COUNT(*) FROM `supehgku_Packagemaker`.`sub_bots`) <= 
              (SELECT COUNT(*) FROM `supehgku_fixed_v2`.`sub_bots`)
         THEN '✅ OK'
         ELSE '❌ MISMATCH'
       END AS status

UNION ALL

SELECT 'steam_accounts',
       (SELECT COUNT(*) FROM `supehgku_Packagemaker`.`steam_accounts`),
       (SELECT COUNT(*) FROM `supehgku_fixed_v2`.`steam_accounts`),
       CASE
         WHEN (SELECT COUNT(*) FROM `supehgku_Packagemaker`.`steam_accounts`) <=
              (SELECT COUNT(*) FROM `supehgku_fixed_v2`.`steam_accounts`)
         THEN '✅ OK'
         ELSE '❌ MISMATCH'
       END

UNION ALL

SELECT 'allowed_users',
       (SELECT COUNT(*) FROM `supehgku_Packagemaker`.`allowed_users`),
       (SELECT COUNT(*) FROM `supehgku_fixed_v2`.`allowed_users`),
       CASE
         WHEN (SELECT COUNT(*) FROM `supehgku_Packagemaker`.`allowed_users`) <=
              (SELECT COUNT(*) FROM `supehgku_fixed_v2`.`allowed_users`)
         THEN '✅ OK'
         ELSE '❌ MISMATCH'
       END

UNION ALL

SELECT 'steam_requests',
       (SELECT COUNT(*) FROM `supehgku_Packagemaker`.`steam_requests`),
       (SELECT COUNT(*) FROM `supehgku_fixed_v2`.`steam_requests`),
       CASE
         WHEN (SELECT COUNT(*) FROM `supehgku_Packagemaker`.`steam_requests`) <=
              (SELECT COUNT(*) FROM `supehgku_fixed_v2`.`steam_requests`)
         THEN '✅ OK'
         ELSE '❌ MISMATCH'
       END;

-- ================================================================================
-- 7. التحقق من Foreign Keys
-- ================================================================================

SELECT '🔗 Foreign Key Integrity Check' AS '═══════════════════════════════════════';

-- التحقق من allowed_users.bot_token → sub_bots.bot_token
SELECT COUNT(*) AS orphaned_allowed_users
FROM `supehgku_fixed_v2`.`allowed_users` au
LEFT JOIN `supehgku_fixed_v2`.`sub_bots` sb ON au.bot_token = sb.bot_token
WHERE sb.bot_token IS NULL;
-- يجب أن تكون النتيجة 0

-- التحقق من steam_requests.bot_token → sub_bots.bot_token
SELECT COUNT(*) AS orphaned_steam_requests_bot
FROM `supehgku_fixed_v2`.`steam_requests` sr
LEFT JOIN `supehgku_fixed_v2`.`sub_bots` sb ON sr.bot_token = sb.bot_token
WHERE sb.bot_token IS NULL;
-- يجب أن تكون النتيجة 0

-- التحقق من steam_requests.account_name → steam_accounts.account_name
SELECT COUNT(*) AS orphaned_steam_requests_account
FROM `supehgku_fixed_v2`.`steam_requests` sr
LEFT JOIN `supehgku_fixed_v2`.`steam_accounts` sa ON sr.account_name = sa.account_name
WHERE sa.account_name IS NULL;
-- يجب أن تكون النتيجة 0

-- ================================================================================
-- 8. التحقق من Triggers (المجموعات الافتراضية)
-- ================================================================================

SELECT '🔄 Trigger Verification' AS '═══════════════════════════════════════';

-- التحقق من أن كل sub_bot في مجموعة default
SELECT COUNT(*) AS bots_without_default_group
FROM `supehgku_fixed_v2`.`sub_bots` sb
LEFT JOIN `supehgku_fixed_v2`.`bot_groups` bg ON sb.id = bg.bot_id
WHERE bg.bot_id IS NULL;
-- يجب أن تكون النتيجة 0

-- التحقق من أن كل steam_account في مجموعة default
SELECT COUNT(*) AS accounts_without_default_group
FROM `supehgku_fixed_v2`.`steam_accounts` sa
LEFT JOIN `supehgku_fixed_v2`.`group_accounts` ga ON sa.id = ga.account_id
WHERE ga.account_id IS NULL;
-- يجب أن تكون النتيجة 0

-- ================================================================================

COMMIT;

SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET SQL_MODE=@OLD_SQL_MODE;

SELECT '✅✅✅ Migration completed successfully! ✅✅✅' AS result;
SELECT 'تم الترحيل بنجاح - يرجى مراجعة النتائج أعلاه' AS message;

-- ================================================================================
-- ملاحظات مهمة بعد الترحيل:
-- ================================================================================
-- 1. قم بضبط limits_global حسب احتياجاتك:
--    UPDATE supehgku_fixed_v2.limits_global 
--    SET mode='weekly', per_day=2, weekly_cap=6, ban_days=7 WHERE id=1;
--
-- 2. اختبر بوت واحد للتأكد من عمل النظام
--
-- 3. راقب system_logs:
--    SELECT * FROM supehgku_fixed_v2.system_logs 
--    ORDER BY created_at DESC LIMIT 50;
--
-- 4. البيانات غير المرحّلة (حسب السياسة):
--    - message_templates (تم الإبقاء على قيم fixed_v2)
--    - daily_attempts من sub_bots (معطّل)
--    - daily_attempts_override من steam_accounts (معطّل)
--    - جميع جداول limits_* (سيتم ضبطها يدوياً)
-- ================================================================================
