 <?php
/**
 * لوحة أوامر الإدارة الشاملة - v2.0
 */

function get_help_sections() {
    return [
        'main' => [
            'text' => "🧠 <b>لوحة أوامر الإدارة الشاملة</b>\n\nاختر القسم:",
            'keyboard' => [
                [['text' => '📁 إدارة البوتات', 'callback_data' => 'help:bots']],
                [['text' => '👥 إدارة المستخدمين', 'callback_data' => 'help:users']],
                [['text' => '🎮 الحسابات', 'callback_data' => 'help:accounts']],
                [['text' => '📂 المجموعات', 'callback_data' => 'help:groups']],
                [['text' => '🎯 نظام الحدود 🆕', 'callback_data' => 'help:limits']],
                [['text' => '🎫 القسائم', 'callback_data' => 'help:vouchers']],
                [['text' => '📢 البث', 'callback_data' => 'help:broadcast']],
                [['text' => '💬 الردود', 'callback_data' => 'help:responses']],
                [['text' => '👨‍💼 المدراء', 'callback_data' => 'help:managers']],
                [['text' => '📊 الإحصائيات', 'callback_data' => 'help:stats']],
                [['text' => '⚙️ الصيانة', 'callback_data' => 'help:system']]
            ]
        ]
    ];
}

function get_help_content($section) {
    // محاولة القراءة من قاعدة البيانات أولاً
    try {
        $db = pdo();
        $key_map = [
            'bots' => 'help_part1',
            'users' => 'help_part2',
            'accounts' => 'help_part3',
            'groups' => 'help_part4',
            'vouchers' => 'help_part5',
            'broadcast' => 'help_part6',
            'responses' => 'help_part7',
            'managers' => 'help_part8',
            'limits' => 'help_part9',
            'stats' => 'help_stats',
            'system' => 'help_system'
        ];
        
        if (isset($key_map[$section])) {
            $stmt = $db->prepare("SELECT text FROM message_templates WHERE `key` = ?");
            $stmt->execute([$key_map[$section]]);
            $result = $stmt->fetch();
            
            if ($result && !empty($result['text'])) {
                return [$result['text']];
            }
        }
    } catch (Exception $e) {
        // إذا فشل، استخدم المحتوى الثابت أدناه
    }
    
    // المحتوى الثابت كـ fallback
    $content = [
        'bots' => [
            "🛠 <b>قسم إدارة البوتات</b>\n\n" .
            "<b>/addbot</b> <code>label token [ch] [max]</code>\n" .
            "➡️ إضافة بوت جديد للنظام\n" .
            "💡 <code>/addbot mybot 123:ABC @ch 100</code>\n\n" .
            "<b>/list</b> - عرض جميع البوتات المسجلة\n\n" .
            "<b>/bot_rename</b> <code>old_label new_label</code> 🆕 - تعديل اسم بوت\n" .
            "💡 <code>/bot_rename test1 test_new</code>\n\n" .
            "<b>/pause</b> <code>label</code> - إيقاف بوت مؤقتاً\n" .
            "<b>/resume</b> <code>label</code> - تشغيل بوت متوقف\n\n" .
            "<b>/setmax</b> <code>label n</code> - تحديد الحد الأقصى للمستخدمين\n" .
            "<b>/incmax</b> <code>label delta</code> - زيادة الحد الأقصى\n\n" .
            "<b>/setchannel</b> <code>label channel_id</code> - قناة الاشتراك\n" .
            "<b>/settoken</b> <code>label token</code> - تحديث التوكن\n" .
            "<b>/setwelcome</b> <code>label text</code> - رسالة الترحيب\n\n" .
            "<b>/bot_details</b> <code>label</code> 🆕 - معلومات تفصيلية عن بوت\n" .
            "💡 <code>/bot_details test1</code>\n\n" .
            "<b>/refreshbot</b> <code>label</code> 🆕 - تحديث Webhook\n" .
            "<b>/deletebot</b> <code>label confirm</code> 🆕 - حذف نهائي\n\n" .
            "⚠️ <i>لتحديد عدد الطلبات: استخدم <code>/help limits</code></i>"
        ],
        
        'users' => [
            "👥 <b>قسم إدارة المستخدمين</b>\n\n" .
            "<b>/users</b> <code>label</code> - مستخدمو بوت معين\n" .
            "<b>/allusers</b> - جميع المستخدمين في النظام\n\n" .
            "<b>/ban</b> <code>user_id [label]</code> - حظر من بوت\n" .
            "<b>/unban</b> <code>user_id [label]</code> - إلغاء الحظر\n\n" .
            "<b>/checkuser</b> <code>user_id</code> - نشاط المستخدم\n" .
            "💡 عرض الطلبات + آخر استخدام\n\n" .
            "<b>/reset_limits</b> <code>user_id</code> 🆕\n" .
            "➡️ إعادة ضبط المحاولات اليومية"
        ],
        
        'accounts' => [
            "🎮 <b>قسم الحسابات</b>\n\n" .
            "<b>/accounts</b> - عرض جميع الحسابات\n\n" .
            "<b>/addaccount</b> <code>name secret</code>\n" .
            "➡️ إضافة حساب Steam Guard\n" .
            "💡 <code>/addaccount main ABC123==</code>\n\n" .
            "<b>/addaccounts</b> - إضافة عدة حسابات\n" .
            "➡️ أرسل بعده: name1:secret1\\nname2:secret2\n\n" .
            "<b>/editaccount</b> <code>name secret [active]</code>\n" .
            "<b>/disableaccount</b> <code>name</code> - تعطيل\n" .
            "<b>/enableaccount</b> <code>name</code> - تفعيل\n\n" .
            "<b>/account_details</b> <code>name_or_id</code> 🆕 - معلومات شاملة\n" .
            "➡️ يعرض: المجموعة، البوتات المرتبطة، الحدود الخاصة\n" .
            "💡 <code>/account_details steamuser1</code>\n" .
            "💡 <code>/account_details 42</code>\n\n" .
            "<b>/deleteaccount</b> <code>name</code> 🆕 - حذف نهائي\n" .
            "<b>/accountinfo</b> <code>name</code> 🆕 - معلومات تفصيلية"
        ],
        
        'groups' => [
            "📂 <b>قسم المجموعات</b> (النظام الجديد) ✨\n\n" .
            "💡 <i>نظام متطور لتجميع الحسابات وربطها بالبوتات</i>\n\n" .
            "<b>📋 إدارة المجموعات:</b>\n" .
            "<b>/group_add</b> <code>name</code> - إنشاء مجموعة جديدة\n" .
            "💡 <code>/group_add vip</code>\n\n" .
            "<b>/group_rename</b> <code>old new</code> - إعادة تسمية 🆕\n" .
            "💡 <code>/group_rename vip premium</code>\n\n" .
            "<b>/group_delete</b> <code>name confirm</code> - حذف نهائي 🆕\n" .
            "💡 <code>/group_delete old confirm</code>\n\n" .
            "<b>/group_lock</b> <code>name</code> - قفل (منع rename/delete) 🆕\n" .
            "<b>/group_unlock</b> <code>name</code> - فتح القفل 🆕\n\n" .
            "<b>/groups_list</b> - عرض جميع المجموعات\n" .
            "💡 يعرض المجموعات مع عداد البوتات والحسابات\n\n" .
            "<b>/group_details</b> <code>name</code> 🆕 - معلومات تفصيلية عن مجموعة\n" .
            "➡️ يعرض: البوتات المرتبطة، الحسابات المرتبطة (بالأسماء والأرقام)\n" .
            "💡 <code>/group_details default</code>\n\n" .
            "<b>/group_info</b> <code>group</code> - تفاصيل مجموعة\n" .
            "💡 <code>/group_info default</code>\n\n" .
            "<b>/group_toggle</b> <code>group</code> - تفعيل/تعطيل\n" .
            "💡 <code>/group_toggle vip</code>\n\n" .
            "<b>/group_usage</b> <code>group</code> - إحصائيات الاستخدام 🆕\n" .
            "💡 <code>/group_usage vip</code>\n\n" .
            "<b>🤖 ربط البوتات:</b>\n" .
            "<b>/group_bind</b> <code>bot group</code> - ربط بوت بمجموعة\n" .
            "💡 <code>/group_bind mybot vip</code>\n\n" .
            "<b>/group_unbind</b> <code>bot group</code> - فك ربط بوت\n" .
            "💡 <code>/group_unbind mybot vip</code>\n\n" .
            "<b>/bot_groups</b> <code>bot</code> - عرض مجموعات وحسابات بوت 🆕\n" .
            "💡 <code>/bot_groups mybot</code>\n\n" .
            "<b>👤 إدارة الحسابات (دفعات):</b>\n" .
            "<b>/group_account_add</b> <code>group acc1 acc2 ...</code> 🆕\n" .
            "➡️ إضافة حسابات لمجموعة (دفعة واحدة)\n" .
            "💡 <code>/group_account_add vip acc1 acc2 acc3</code>\n\n" .
            "<b>/group_account_del</b> <code>group acc1 acc2 ...</code> 🆕\n" .
            "➡️ إزالة حسابات من مجموعة (دفعة واحدة)\n" .
            "💡 <code>/group_account_del vip acc1 acc2</code>\n\n" .
            "⚠️ <i>البوت يرى فقط الحسابات الموجودة في مجموعاته</i>"
        ],
        
        'vouchers' => [
            "🎫 <b>قسم القسائم</b> 🆕\n\n" .
            "💡 <i>لزيادة حدود المستخدمين أو إضافة أيام</i>\n\n" .
            "<b>/generate_voucher</b> <code>type amount [bot] [uses]</code>\n" .
            "➡️ إنشاء قسيمة جديدة\n\n" .
            "<b>الأنواع:</b> users | days\n\n" .
            "💡 <code>/generate_voucher users 100 mybot 1</code>\n" .
            "💡 <code>/generate_voucher users 50 all 5</code>\n\n" .
            "<b>/redeem</b> <code>code [bot]</code> - تفعيل قسيمة\n" .
            "💡 <code>/redeem ABC123 mybot</code>\n\n" .
            "<b>/vouchers</b> - عرض جميع القسائم\n" .
            "<b>/voucher_search</b> <code>code</code> - بحث عن قسيمة\n\n" .
            "<b>/voucher_who_used</b> <code>code</code> - تقرير الاستخدام 🆕\n" .
            "💡 <code>/voucher_who_used ABC123</code>\n" .
            "➡️ يعرض البوتات التي استخدمت القسيمة مع التواريخ"
        ],
        
        'broadcast' => [
            "📢 <b>قسم البث</b>\n\n" .
            "<b>/broadcast</b> <code>label text</code>\n" .
            "➡️ إرسال رسالة لمستخدمي بوت معين\n" .
            "💡 <code>/broadcast mybot مرحباً</code>\n\n" .
            "<b>/broadcast_all</b> <code>text</code>\n" .
            "➡️ إرسال لجميع مستخدمي كل البوتات\n\n" .
            "⚠️ <i>يتم الإرسال مع تأخير 0.2s لتجنب حدود Telegram</i>"
        ],
        
        'responses' => [
            "💬 <b>قسم الردود</b> (محسّن) ✨\n\n" .
            "💡 <i>نظام ردود متقدم: عامة لكل البوتات أو مخصصة لبوت واحد</i>\n\n" .
            "<b>📋 عرض الردود:</b>\n" .
            "<b>/responses</b> - عرض الردود العامة\n" .
            "<b>/bot_responses</b> <code>bot</code> - ردود بوت مخصصة 🆕\n" .
            "💡 <code>/bot_responses mybot</code>\n\n" .
            "<b>✏️ تعديل الردود العامة:</b>\n" .
            "<b>/edit_global_response</b> <code>key text</code> 🆕\n" .
            "➡️ يُحدّث رد عام لجميع البوتات\n" .
            "💡 <code>/edit_global_response start_1 مرحباً!</code>\n\n" .
            "<b>/editresponse</b> <code>key text</code>\n" .
            "➡️ نفس الأمر أعلاه (قديم)\n\n" .
            "<b>🤖 تعديل ردود بوت معين:</b>\n" .
            "<b>/edit_bot_response</b> <code>bot key text</code> 🆕\n" .
            "➡️ رد مخصص لبوت واحد فقط\n" .
            "💡 <code>/edit_bot_response mybot start_1 مرحباً في بوتي!</code>\n\n" .
            "<b>🔧 أوامر إضافية:</b>\n" .
            "<b>/copy_global_to_bot</b> <code>key bot</code> 🆕\n" .
            "➡️ نسخ رد عام ليصبح مخصص لبوت\n\n" .
            "<b>/delete_bot_response</b> <code>bot key</code> 🆕\n" .
            "➡️ حذف رد مخصص (يعود للرد العام)\n\n" .
            "<b>📚 القوالب المتاحة:</b>\n" .
            "• <code>start_1</code> - رسالة البداية\n" .
            "• <code>code_reply</code> - رد الكود\n" .
            "• <code>invalid_account</code> - حساب خاطئ\n" .
            "• <code>rate_limited</code> - تجاوز الحد\n" .
            "• <code>paused</code> - بوت متوقف"
        ],
        
        'stats' => [
            "📊 <b>قسم الإحصائيات</b>\n\n" .
            "<b>/stats</b> - إحصائيات عامة\n" .
            "<b>/stats</b> <code>label</code> - إحصائيات بوت معين\n\n" .
            "<b>البيانات:</b>\n" .
            "• عدد المستخدمين\n" .
            "• عدد البوتات\n" .
            "• عدد الحسابات النشطة\n" .
            "• عدد المجموعات\n" .
            "• عدد القسائم\n" .
            "• إجمالي الأكواد المسحوبة"
        ],
        
        'limits' => [
            "🎯 <b>نظام الحدود الذكي</b> 🆕✨\n\n" .
            "💡 <i>نظام متقدم مع 3 أوضاع: يومي/أسبوعي/شهري</i>\n\n" .
            "<b>📋 الحدود العامة:</b>\n" .
            "<b>/limit_mode_all</b> <code>mode</code>\n" .
            "➡️ تغيير الوضع العام (daily/weekly/monthly)\n" .
            "💡 <code>/limit_mode_all weekly</code>\n\n" .
            "<b>/set_daily_all</b> <code>per_day</code>\n" .
            "➡️ تعيين حد يومي عام\n" .
            "💡 <code>/set_daily_all 3</code>\n\n" .
            "<b>/set_weekly_all</b> <code>per_day weekly_cap ban_days</code>\n" .
            "➡️ حد أسبوعي: يومي + سقف أسبوعي + مدة حظر\n" .
            "💡 <code>/set_weekly_all 2 6 7</code>\n\n" .
            "<b>/set_monthly_all</b> <code>per_day monthly_cap ban_days</code>\n" .
            "➡️ حد شهري: يومي + سقف شهري + مدة حظر\n" .
            "💡 <code>/set_monthly_all 2 20 30</code>\n\n" .
            "<b>🤖 حدود البوتات:</b>\n" .
            "<b>/limit_mode</b> <code>bot mode</code>\n" .
            "➡️ تعيين وضع خاص لبوت محدد\n" .
            "💡 <code>/limit_mode mybot weekly</code>\n\n" .
            "<b>👤 التجاوز (حدود خاصة):</b>\n" .
            "<b>/override_account</b> <code>id mode per_day [cap] [ban]</code>\n" .
            "➡️ حدود مخصصة لحساب محدد (أعلى أولوية)\n" .
            "💡 <code>/override_account 5 weekly 3 10 7</code>\n" .
            "💡 <code>/override_account 5 daily 10</code>\n\n" .
            "<b>/override_clear</b> <code>id</code> - حذف التجاوز\n\n" .
            "<b>📊 الاستعلام:</b>\n" .
            "<b>/show_limit</b> <code>target</code>\n" .
            "➡️ عرض الحدود (global/bot/account_id)\n" .
            "💡 <code>/show_limit global</code>\n" .
            "💡 <code>/show_limit mybot</code>\n" .
            "💡 <code>/show_limit 5</code>\n\n" .
            "<b>/reset_counters</b> <code>target</code>\n" .
            "➡️ إعادة تعيين العدادات (user_id/all)\n" .
            "💡 <code>/reset_counters 123456789</code>\n\n" .
            "<b>⛔ الحظر:</b>\n" .
            "<b>/ban_from_account</b> <code>user_id account_id days</code>\n" .
            "➡️ حظر مستخدم من حساب لمدة محددة\n" .
            "💡 <code>/ban_from_account 123456789 5 7</code>\n\n" .
            "<b>/unban_from_account</b> <code>user_id account_id</code>\n" .
            "➡️ إلغاء حظر مستخدم من حساب\n\n" .
            "<b>💬 الرسائل:</b>\n" .
            "<b>/msg_set</b> <code>event text</code> - تخصيص رسالة\n" .
            "💡 <code>/msg_set on_limit_hit وصلت للحد!</code>\n\n" .
            "<b>/msg_show</b> - عرض جميع الرسائل\n\n" .
            "<b>📌 الأوضاع:</b>\n" .
            "🔹 <b>daily</b>: 2 كود/يوم (رفض فوري)\n" .
            "🔹 <b>weekly</b>: 2 كود/يوم + 6/أسبوع (حظر 7 أيام)\n" .
            "🔹 <b>monthly</b>: 2 كود/يوم + 20/شهر (حظر 30 يوم)\n\n" .
            "⚙️ <i>الأولوية: override → bot → global</i>"
        ],
        
        'managers' => [
            "👨‍💼 <b>قسم المدراء الفرعيين</b> 🆕\n\n" .
            "💡 <i>يمكنك إضافة مدراء لمساعدتك في إدارة البوتات</i>\n\n" .
            "<b>/managers_all</b> - عرض جميع المدراء\n" .
            "➡️ قائمة شاملة بكل المدراء في النظام\n\n" .
            "<b>/managers</b> <code>label</code>\n" .
            "➡️ عرض مدراء بوت معين\n" .
            "💡 <code>/managers mybot</code>\n\n" .
            "<b>/addmanager</b> <code>label user_id [perms]</code>\n" .
            "➡️ إضافة مدير لبوت محدد\n" .
            "💡 <code>/addmanager mybot 123456 1:2:3</code>\n" .
            "💡 <code>/addmanager mybot 123456 all</code>\n\n" .
            "<b>/addmanager_all</b> <code>user_id [perms]</code>\n" .
            "➡️ إضافة مدير عام لكل البوتات\n" .
            "💡 <code>/addmanager_all 123456 all</code>\n\n" .
            "<b>/removemanager</b> <code>label user_id</code>\n" .
            "➡️ إزالة مدير من بوت محدد\n\n" .
            "<b>/removemanager_all</b> <code>user_id</code>\n" .
            "➡️ إزالة مدير من كل البوتات\n\n" .
            "<b>/managerinfo</b> <code>user_id</code>\n" .
            "➡️ عرض صلاحيات مدير معين\n\n" .
            "<b>📋 الصلاحيات المتاحة:</b>\n" .
            "1️⃣ بث (Broadcast)\n" .
            "2️⃣ حظر (Ban/Unban)\n" .
            "3️⃣ تعبئة قسائم (Vouchers)\n" .
            "4️⃣ عرض المستخدمين\n" .
            "5️⃣ البحث عن مستخدم\n" .
            "6️⃣ تعديل حدود المستخدم\n" .
            "✨ <code>all</code> - كل الصلاحيات\n\n" .
            "⚠️ <i>الصلاحيات تُفصل بـ <code>:</code> مثل <code>1:2:3</code></i>"
        ],
        
        'system' => [
            "⚙️ <b>قسم الصيانة</b> 🆕\n\n" .
            "<b>/system_status</b> - فحص حالة النظام\n" .
            "➡️ يعرض:\n" .
            "✅ قاعدة البيانات\n" .
            "✅ البوتات\n" .
            "✅ المستخدمون\n" .
            "✅ الحسابات النشطة\n" .
            "✅ المجموعات\n\n" .
            "<b>/help</b> - هذه القائمة\n" .
            "<b>/start</b> - رسالة البداية"
        ]
    ];
    
    return $content[$section] ?? ["❌ القسم غير موجود"];
}