<?php
/**
 * صيانة نظام الحدود - Cron Job
 * 
 * استخدام:
 * */5 * * * * php /path/to/cron_limits_maintenance.php
 */

$timestamp = date('Y-m-d H:i:s');

try {
    // الاتصال بقاعدة البيانات
    if (file_exists(__DIR__ . '/.env.php')) {
        require_once __DIR__ . '/.env.php';
        $db = new PDO("mysql:host={$host};dbname={$dbname};charset=utf8mb4", $user, $pass);
    } else {
        // عدّل هذه القيم
        $host = 'localhost';
        $dbname = 'database_name';  // عدّل
        $user = 'username';         // عدّل
        $pass = 'password';         // عدّل
        
        $db = new PDO("mysql:host={$host};dbname={$dbname};charset=utf8mb4", $user, $pass);
    }
    
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "[{$timestamp}] 🔗 متصل بقاعدة البيانات\n";
    
    // 1. إعادة تعيين العدادات
    $db->query("CALL reset_expired_counters()");
    echo "[{$timestamp}] ✅ تم إعادة تعيين العدادات\n";
    
    // 2. حذف الحظر المنتهي
    $db->query("CALL cleanup_expired_bans()");
    echo "[{$timestamp}] ✅ تم حذف الحظر المنتهي\n";
    
    echo "[{$timestamp}] 🎉 اكتملت الصيانة بنجاح\n";
    
} catch (PDOException $e) {
    echo "[{$timestamp}] ❌ خطأ: " . $e->getMessage() . "\n";
    exit(1);
}
