-- ================================================================
-- تحديث رسائل الأوامر الجديدة في message_templates
-- ================================================================
-- التاريخ: 2025-10-25
-- الهدف: إضافة قوالب الرسائل للأوامر الجديدة
-- ملاحظة: الجدول يحتوي فقط على (key, text)
-- ================================================================

-- ═══════════════════════════════════════════════════════════════
-- 1. رسائل تعديل اسم البوت
-- ═══════════════════════════════════════════════════════════════

INSERT INTO `message_templates` (`key`, `text`) VALUES
('bot_rename_success', 
'✅ <b>تم تعديل اسم البوت بنجاح!</b>\n\nالاسم القديم: <code>{old_label}</code>\nالاسم الجديد: <code>{new_label}</code>\n\n⚠️ <b>ملاحظة:</b> سيتم تحديث:\n• الحدود الخاصة بالبوت\n• العدادات المرتبطة\n• الحظر المرتبط\nتلقائياً (Foreign Key Cascade)')
ON DUPLICATE KEY UPDATE text = VALUES(text);

INSERT INTO `message_templates` (`key`, `text`) VALUES
('bot_rename_not_found', 
'❌ البوت <b>{label}</b> غير موجود')
ON DUPLICATE KEY UPDATE text = VALUES(text);

INSERT INTO `message_templates` (`key`, `text`) VALUES
('bot_rename_exists', 
'❌ الاسم <b>{label}</b> مستخدم بالفعل')
ON DUPLICATE KEY UPDATE text = VALUES(text);

INSERT INTO `message_templates` (`key`, `text`) VALUES
('bot_rename_usage', 
'❌ <b>الاستخدام:</b>\n<code>/bot_rename &lt;label_قديم&gt; &lt;label_جديد&gt;</code>\n\n💡 <i>مثال:</i> <code>/bot_rename test1 test_new</code>')
ON DUPLICATE KEY UPDATE text = VALUES(text);

-- ═══════════════════════════════════════════════════════════════
-- 2. رسائل استعلام عن مجموعة
-- ═══════════════════════════════════════════════════════════════

INSERT INTO `message_templates` (`key`, `text`) VALUES
('group_details_header', 
'📂 <b>معلومات المجموعة: {group_name}</b>{default_badge}\n\n🔹 <b>الحالة:</b> {status}\n🔹 <b>الوصف:</b> {description}\n\n')
ON DUPLICATE KEY UPDATE text = VALUES(text);

INSERT INTO `message_templates` (`key`, `text`) VALUES
('group_details_not_found', 
'❌ المجموعة <b>{group_name}</b> غير موجودة')
ON DUPLICATE KEY UPDATE text = VALUES(text);

INSERT INTO `message_templates` (`key`, `text`) VALUES
('group_details_usage', 
'❌ <b>الاستخدام:</b>\n<code>/group_details &lt;group_name&gt;</code>\n\n💡 <i>مثال:</i> <code>/group_details default</code>')
ON DUPLICATE KEY UPDATE text = VALUES(text);

-- ═══════════════════════════════════════════════════════════════
-- 3. رسائل استعلام عن بوت
-- ═══════════════════════════════════════════════════════════════

INSERT INTO `message_templates` (`key`, `text`) VALUES
('bot_details_header', 
'🤖 <b>معلومات البوت: {bot_label}</b>\n\n🔹 <b>ID:</b> {bot_id}\n🔹 <b>الحالة:</b> {status}\n🔹 <b>الحد الأقصى للمستخدمين:</b> {max_users}\n\n')
ON DUPLICATE KEY UPDATE text = VALUES(text);

INSERT INTO `message_templates` (`key`, `text`) VALUES
('bot_details_not_found', 
'❌ البوت <b>{bot_label}</b> غير موجود')
ON DUPLICATE KEY UPDATE text = VALUES(text);

INSERT INTO `message_templates` (`key`, `text`) VALUES
('bot_details_usage', 
'❌ <b>الاستخدام:</b>\n<code>/bot_details &lt;bot_label&gt;</code>\n\n💡 <i>مثال:</i> <code>/bot_details test1</code>')
ON DUPLICATE KEY UPDATE text = VALUES(text);

-- ═══════════════════════════════════════════════════════════════
-- 4. رسائل استعلام عن حساب
-- ═══════════════════════════════════════════════════════════════

INSERT INTO `message_templates` (`key`, `text`) VALUES
('account_details_header', 
'👤 <b>معلومات الحساب: {account_name}</b>\n\n🔹 <b>ID:</b> {account_id}\n🔹 <b>الحالة:</b> {status}\n🔹 <b>كلمة المرور:</b> <code>{password}</code>\n🔹 <b>Steam Guard:</b> {steam_guard}\n\n')
ON DUPLICATE KEY UPDATE text = VALUES(text);

INSERT INTO `message_templates` (`key`, `text`) VALUES
('account_details_not_found', 
'❌ الحساب <b>{account}</b> غير موجود')
ON DUPLICATE KEY UPDATE text = VALUES(text);

INSERT INTO `message_templates` (`key`, `text`) VALUES
('account_details_usage', 
'❌ <b>الاستخدام:</b>\n<code>/account_details &lt;account_name أو ID&gt;</code>\n\n💡 <i>مثال:</i> <code>/account_details steamuser123</code>\nأو: <code>/account_details 42</code>')
ON DUPLICATE KEY UPDATE text = VALUES(text);

-- ═══════════════════════════════════════════════════════════════
-- 5. رسائل عامة
-- ═══════════════════════════════════════════════════════════════

INSERT INTO `message_templates` (`key`, `text`) VALUES
('groups_list_header', 
'📂 <b>قائمة المجموعات:</b>\n\n')
ON DUPLICATE KEY UPDATE text = VALUES(text);

INSERT INTO `message_templates` (`key`, `text`) VALUES
('groups_list_empty', 
'لا توجد مجموعات')
ON DUPLICATE KEY UPDATE text = VALUES(text);

-- ================================================================
-- ✅ تم تحديث قوالب الرسائل!
-- ================================================================

-- التحقق من النتائج
SELECT `key`, LEFT(`text`, 80) as preview
FROM message_templates
WHERE `key` LIKE '%details%' OR `key` LIKE '%rename%'
ORDER BY `key`;
