-- ================================================================
-- تحديث رسائل الأوامر الجديدة في message_templates
-- ================================================================
-- التاريخ: 2025-10-25
-- الهدف: إضافة قوالب الرسائل للأوامر الجديدة
-- ================================================================

-- ═══════════════════════════════════════════════════════════════
-- 1. رسالة تعديل اسم البوت
-- ═══════════════════════════════════════════════════════════════

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('bot_rename_success', 
'✅ <b>تم تعديل اسم البوت بنجاح!</b>\n\nالاسم القديم: <code>{old_label}</code>\nالاسم الجديد: <code>{new_label}</code>\n\n⚠️ <b>ملاحظة:</b> سيتم تحديث:\n• الحدود الخاصة بالبوت\n• العدادات المرتبطة\n• الحظر المرتبط\nتلقائياً (Foreign Key Cascade)',
'رسالة نجاح تعديل اسم البوت',
'bot_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('bot_rename_not_found', 
'❌ البوت <b>{label}</b> غير موجود',
'رسالة عدم وجود البوت عند التعديل',
'bot_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('bot_rename_exists', 
'❌ الاسم <b>{label}</b> مستخدم بالفعل',
'رسالة وجود الاسم الجديد',
'bot_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('bot_rename_usage', 
'❌ <b>الاستخدام:</b>\n<code>/bot_rename &lt;label_قديم&gt; &lt;label_جديد&gt;</code>\n\n💡 <i>مثال:</i> <code>/bot_rename test1 test_new</code>',
'رسالة طريقة استخدام أمر تعديل اسم البوت',
'bot_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

-- ═══════════════════════════════════════════════════════════════
-- 2. رسالة استعلام عن مجموعة
-- ═══════════════════════════════════════════════════════════════

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('group_details_header', 
'📂 <b>معلومات المجموعة: {group_name}</b>{default_badge}\n\n🔹 <b>الحالة:</b> {status}\n🔹 <b>الوصف:</b> {description}\n\n',
'رأس معلومات المجموعة',
'group_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('group_details_bots', 
'🤖 <b>البوتات المرتبطة:</b> ({count})\n{bots_list}',
'قائمة البوتات في المجموعة',
'group_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('group_details_accounts', 
'👤 <b>الحسابات المرتبطة:</b> ({count})\n{accounts_list}',
'قائمة الحسابات في المجموعة',
'group_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('group_details_not_found', 
'❌ المجموعة <b>{group_name}</b> غير موجودة',
'رسالة عدم وجود المجموعة',
'group_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('group_details_usage', 
'❌ <b>الاستخدام:</b>\n<code>/group_details &lt;group_name&gt;</code>\n\n💡 <i>مثال:</i> <code>/group_details default</code>',
'رسالة طريقة استخدام أمر استعلام المجموعة',
'group_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

-- ═══════════════════════════════════════════════════════════════
-- 3. رسالة استعلام عن بوت
-- ═══════════════════════════════════════════════════════════════

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('bot_details_header', 
'🤖 <b>معلومات البوت: {bot_label}</b>\n\n🔹 <b>ID:</b> {bot_id}\n🔹 <b>الحالة:</b> {status}\n🔹 <b>الحد الأقصى للمستخدمين:</b> {max_users}\n\n',
'رأس معلومات البوت',
'bot_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('bot_details_groups', 
'📂 <b>المجموعات المرتبطة:</b> ({count})\n{groups_list}',
'قائمة المجموعات المرتبطة بالبوت',
'bot_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('bot_details_accounts', 
'👤 <b>الحسابات المرتبطة:</b> ({count})\n{accounts_list}',
'قائمة الحسابات المرتبطة بالبوت',
'bot_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('bot_details_limits', 
'⚙️ <b>الحدود الخاصة بالبوت:</b>\n{limits_info}',
'معلومات حدود البوت',
'bot_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('bot_details_not_found', 
'❌ البوت <b>{bot_label}</b> غير موجود',
'رسالة عدم وجود البوت',
'bot_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('bot_details_usage', 
'❌ <b>الاستخدام:</b>\n<code>/bot_details &lt;bot_label&gt;</code>\n\n💡 <i>مثال:</i> <code>/bot_details test1</code>',
'رسالة طريقة استخدام أمر استعلام البوت',
'bot_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

-- ═══════════════════════════════════════════════════════════════
-- 4. رسالة استعلام عن حساب
-- ═══════════════════════════════════════════════════════════════

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('account_details_header', 
'👤 <b>معلومات الحساب: {account_name}</b>\n\n🔹 <b>ID:</b> {account_id}\n🔹 <b>الحالة:</b> {status}\n🔹 <b>كلمة المرور:</b> <code>{password}</code>\n🔹 <b>Steam Guard:</b> {steam_guard}\n\n',
'رأس معلومات الحساب',
'account_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('account_details_group', 
'📂 <b>المجموعة المرتبطة:</b>\n{group_info}',
'معلومات المجموعة المرتبطة بالحساب',
'account_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('account_details_bots', 
'🤖 <b>البوتات المرتبطة:</b> ({count})\n{bots_list}',
'قائمة البوتات المرتبطة بالحساب',
'account_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('account_details_limits', 
'⚙️ <b>الحدود الخاصة:</b>\n{limits_info}',
'معلومات حدود الحساب',
'account_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('account_details_not_found', 
'❌ الحساب <b>{account}</b> غير موجود',
'رسالة عدم وجود الحساب',
'account_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('account_details_usage', 
'❌ <b>الاستخدام:</b>\n<code>/account_details &lt;account_name أو ID&gt;</code>\n\n💡 <i>مثال:</i> <code>/account_details steamuser123</code>\nأو: <code>/account_details 42</code>',
'رسالة طريقة استخدام أمر استعلام الحساب',
'account_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

-- ═══════════════════════════════════════════════════════════════
-- 5. تحديث رسالة قائمة المجموعات (groups_list)
-- ═══════════════════════════════════════════════════════════════

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('groups_list_header', 
'📂 <b>قائمة المجموعات:</b>\n\n',
'رأس قائمة المجموعات',
'group_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('groups_list_item', 
'{status} <b>{group_name}</b>{default_badge}\n   🤖 {bots_count} بوت | 👤 {accounts_count} حساب\n\n',
'عنصر في قائمة المجموعات',
'group_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

INSERT INTO `message_templates` (`key`, `text`, `description`, `category`) VALUES
('groups_list_empty', 
'لا توجد مجموعات',
'رسالة عدم وجود مجموعات',
'group_management')
ON DUPLICATE KEY UPDATE 
text = VALUES(text),
description = VALUES(description);

-- ================================================================
-- ✅ تم تحديث قوالب الرسائل!
-- ================================================================
-- الأوامر الجديدة:
-- • /bot_rename
-- • /group_details
-- • /bot_details
-- • /account_details
-- ================================================================

-- التحقق من النتائج
SELECT 
    `key`,
    LEFT(`text`, 50) as preview,
    category
FROM message_templates
WHERE category IN ('bot_management', 'group_management', 'account_management')
  AND `key` LIKE '%details%' OR `key` LIKE '%rename%'
ORDER BY category, `key`;
