# 📊 تقرير المقارنة الشاملة بين القاعدتين

**التاريخ:** 2025-10-25  
**المحلل:** Auto Migration System  
**الحالة:** ✅ تحليل مكتمل

---

## 📋 ملخص تنفيذي

### القواعد
| القاعدة | الاسم | الجداول | الحالة |
|---------|-------|---------|--------|
| 🗄️ القديمة | `supehgku_Packagemaker` | 6 جداول | 🟢 نشطة - تحتوي بيانات حقيقية |
| 🗄️ الجديدة | `supehgku_test0` | 20+ جدول | 🔵 محدّثة - بنية متقدمة |

---

## 📊 تحليل الجداول

### 1️⃣ الجداول المشتركة (متطابقة البنية)

#### ✅ `sub_bots` - بوتات فرعية

**البنية القديمة:**
```sql
CREATE TABLE `sub_bots` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(64) NOT NULL,
  `bot_token` varchar(128) NOT NULL,
  `channel_id` varchar(128) DEFAULT NULL,
  `max_users` int(11) DEFAULT 0,
  `current_users` int(11) DEFAULT 0,
  `paused` tinyint(1) DEFAULT 0,
  `welcome_message` text DEFAULT NULL,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `label` (`label`),
  UNIQUE KEY `bot_token` (`bot_token`)
)
```

**البنية الجديدة:**
```sql
CREATE TABLE `sub_bots` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(64) NOT NULL,
  `bot_token` varchar(128) NOT NULL,
  `channel_id` varchar(128) DEFAULT NULL,
  `max_users` int(11) DEFAULT 0,
  `current_users` int(11) DEFAULT 0,
  `paused` tinyint(1) DEFAULT 0,
  `welcome_message` text DEFAULT NULL,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `label` (`label`),
  UNIQUE KEY `bot_token` (`bot_token`)
)
```

**التطابق:** ✅ 100% - يمكن النقل المباشر

**استراتيجية الترحيل:**
```sql
INSERT IGNORE INTO new_db.sub_bots 
SELECT * FROM old_db.sub_bots;
```

---

#### ✅ `steam_accounts` - حسابات Steam Guard

**البنية القديمة:**
```sql
CREATE TABLE `steam_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_name` varchar(64) NOT NULL,
  `shared_secret` varchar(255) NOT NULL,
  `active` tinyint(1) DEFAULT 1,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `account_name` (`account_name`)
)
```

**البنية الجديدة:**
```sql
CREATE TABLE `steam_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_name` varchar(64) NOT NULL,
  `shared_secret` varchar(255) NOT NULL,
  `active` tinyint(1) DEFAULT 1,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `account_name` (`account_name`)
)
```

**التطابق:** ✅ 100% - يمكن النقل المباشر

**استراتيجية الترحيل:**
```sql
INSERT IGNORE INTO new_db.steam_accounts 
SELECT * FROM old_db.steam_accounts;

-- ثم ربط كل حساب بالمجموعة الافتراضية
INSERT IGNORE INTO new_db.group_accounts (group_id, account_id)
SELECT 1, id FROM new_db.steam_accounts;
```

---

#### ✅ `allowed_users` - مستخدمون مسموح لهم

**البنية القديمة:**
```sql
CREATE TABLE `allowed_users` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `bot_token` varchar(128) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `banned` tinyint(1) DEFAULT 0,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_user_bot` (`bot_token`, `user_id`)
)
```

**البنية الجديدة:**
```sql
CREATE TABLE `allowed_users` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `bot_token` varchar(128) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `banned` tinyint(1) DEFAULT 0,
  `daily_attempts` int(11) DEFAULT 0,  -- ⚠️ حقل جديد
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_user_bot` (`bot_token`, `user_id`)
)
```

**الفرق:** ⚠️ حقل `daily_attempts` جديد

**استراتيجية الترحيل:**
```sql
INSERT IGNORE INTO new_db.allowed_users (id, bot_token, user_id, banned, created_at)
SELECT id, bot_token, user_id, banned, created_at 
FROM old_db.allowed_users;
-- daily_attempts سيأخذ القيمة الافتراضية 0
```

---

#### ✅ `message_templates` - قوالب الرسائل

**البنية:**
```sql
CREATE TABLE `message_templates` (
  `key` varchar(64) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`key`)
)
```

**التطابق:** ✅ 100%

**استراتيجية:**
```sql
INSERT IGNORE INTO new_db.message_templates 
SELECT * FROM old_db.message_templates
ON DUPLICATE KEY UPDATE text = VALUES(text);
```

---

#### ✅ `steam_requests` - سجل الطلبات

**البنية متطابقة تماماً**

**استراتيجية:**
```sql
INSERT IGNORE INTO new_db.steam_requests 
SELECT * FROM old_db.steam_requests;
```

---

#### ✅ `control_sessions` - جلسات التحكم

**البنية متطابقة تماماً**

**استراتيجية:**
```sql
-- يُنصح بعدم نقل الجلسات القديمة (ستنتهي صلاحيتها)
-- أو نقل فقط الحديثة:
INSERT IGNORE INTO new_db.control_sessions 
SELECT * FROM old_db.control_sessions 
WHERE created_at > DATE_SUB(NOW(), INTERVAL 24 HOUR);
```

---

### 2️⃣ الجداول الجديدة (تحتاج بيانات مولّدة)

#### 🆕 `account_groups` - مجموعات الحسابات

**الغرض:** تنظيم الحسابات في مجموعات

**البيانات الافتراضية:**
```sql
INSERT INTO account_groups (id, group_name, description, is_default, locked) VALUES
(1, 'default', 'المجموعة العامة - تحتوي جميع الحسابات', 1, 1);
```

**استراتيجية الترحيل:**
- المجموعة `id=1` موجودة مسبقاً (default)
- كل الحسابات المنقولة ستُربط بها

---

#### 🆕 `group_accounts` - ربط حسابات بمجموعات

**الغرض:** علاقة many-to-many بين الحسابات والمجموعات

**استراتيجية الترحيل:**
```sql
-- ربط كل حساب بالمجموعة الافتراضية
INSERT IGNORE INTO group_accounts (group_id, account_id)
SELECT 1, id FROM steam_accounts;
```

---

#### 🆕 `bot_groups` - ربط بوتات بمجموعات

**الغرض:** ربط كل بوت بالمجموعات التي يمكنه الوصول إليها

**استراتيجية الترحيل:**
```sql
-- ربط كل بوت بالمجموعة الافتراضية
INSERT IGNORE INTO bot_groups (bot_id, group_id)
SELECT id, 1 FROM sub_bots;
```

---

#### 🆕 `limit_counters` - عدادات الحدود

**الغرض:** تتبع استخدام كل مستخدم لكل حساب

**استراتيجية:**
- يُنشأ تلقائياً عند أول استخدام
- أو يمكن توليده من `steam_requests`:
```sql
INSERT IGNORE INTO limit_counters (user_id, account_id, day_used, week_used, month_used)
SELECT 
    sr.user_id,
    sa.id as account_id,
    COUNT(CASE WHEN DATE(sr.created_at) = CURDATE() THEN 1 END) as day_used,
    COUNT(CASE WHEN YEARWEEK(sr.created_at) = YEARWEEK(NOW()) THEN 1 END) as week_used,
    COUNT(CASE WHEN MONTH(sr.created_at) = MONTH(NOW()) THEN 1 END) as month_used
FROM steam_requests sr
JOIN steam_accounts sa ON sa.account_name = sr.account_name
GROUP BY sr.user_id, sa.id;
```

---

#### 🆕 الجداول الأخرى

| الجدول | الحالة | ملاحظات |
|--------|--------|----------|
| `bot_message_templates` | فارغ | ردود مخصصة - يُملأ لاحقاً |
| `limits_bot` | فارغ | حدود مخصصة للبوتات |
| `limits_global` | افتراضي | يحتوي إعدادات افتراضية |
| `limits_override` | فارغ | تجاوزات حدود |
| `limit_bans` | فارغ | الحظر - يُملأ لاحقاً |
| `limit_messages` | افتراضي | رسائل الأحداث |
| `bot_managers` | فارغ | مدراء فرعيون |
| `broadcast_*` | فارغ | نظام البث |
| `vouchers` | فارغ | نظام القسائم |
| `system_logs` | فارغ | سجل النظام |

---

## 🔄 خريطة الترحيل

### المرحلة 1: البيانات الأساسية (Core Data)
```
1. sub_bots             → ✅ نقل مباشر
2. steam_accounts       → ✅ نقل مباشر
3. allowed_users        → ✅ نقل مباشر (بدون daily_attempts)
4. message_templates    → ✅ نقل مباشر (merge)
```

### المرحلة 2: الربط (Linking)
```
5. group_accounts       → 🔗 ربط كل حساب بـ group_id=1
6. bot_groups           → 🔗 ربط كل بوت بـ group_id=1
```

### المرحلة 3: البيانات الاختيارية (Optional)
```
7. steam_requests       → ⚠️ اختياري (تاريخ الطلبات)
8. control_sessions     → ⚠️ اختياري (جلسات قديمة)
9. limit_counters       → 🔄 مُحسوب من steam_requests
```

---

## ⚠️ المخاطر والاحتياطات

### 1. Foreign Key Constraints
**المشكلة:** الجداول الجديدة تحتوي على FK قوية

**الحل:**
```sql
SET FOREIGN_KEY_CHECKS=0;
-- ... ترحيل ...
SET FOREIGN_KEY_CHECKS=1;
```

### 2. Auto Increment Conflicts
**المشكلة:** قد تتعارض IDs

**الحل:**
```sql
-- نقل بالـ IDs الأصلية
INSERT IGNORE ...
-- ثم تحديث auto_increment
ALTER TABLE sub_bots AUTO_INCREMENT = <max_id + 1>;
```

### 3. Duplicate Detection
**المشكلة:** بيانات مكررة

**الحل:**
```sql
INSERT IGNORE ... -- تجاهل المكرر
-- أو
ON DUPLICATE KEY UPDATE ... -- تحديث
```

---

## 📈 الإحصائيات المتوقعة

### من القاعدة القديمة:
| الجدول | السجلات المتوقعة |
|--------|-----------------|
| `sub_bots` | ~10-20 |
| `steam_accounts` | ~50-100 |
| `allowed_users` | ~200-500 |
| `steam_requests` | ~10,000+ |
| `message_templates` | ~10-20 |

### إلى القاعدة الجديدة:
| الجدول | السجلات بعد الترحيل |
|--------|---------------------|
| `sub_bots` | نفس العدد |
| `steam_accounts` | نفس العدد |
| `group_accounts` | = عدد steam_accounts |
| `bot_groups` | = عدد sub_bots |
| `allowed_users` | نفس العدد |
| `limit_counters` | = مستخدمين × حسابات مستخدمة |

---

## ✅ معايير النجاح

1. ✅ **سلامة البيانات:** جميع السجلات منقولة بدون فقد
2. ✅ **العلاقات:** كل بوت وحساب مربوط بالمجموعة الافتراضية
3. ✅ **القيود:** جميع FK صحيحة
4. ✅ **الفهارس:** جميع الفهارس سليمة
5. ✅ **الوظيفة:** النظام يعمل فوراً بعد الترحيل

---

## 🚀 الخطوة التالية

→ مراجعة `MIGRATION_PLAN.md`  
→ تنفيذ `migrate.php`

---

*تم التحليل: 2025-10-25 03:40 UTC+03*
