-- ============================================
-- اختبار سريع للأوامر
-- ============================================

-- 1. التحقق من وجود الجداول
-- ============================================
SELECT 'Checking tables...' AS step;

SELECT 
    'message_templates' AS table_name,
    COUNT(*) AS count
FROM message_templates;

SELECT 
    'limit_messages' AS table_name,
    COUNT(*) AS count
FROM limit_messages;

SELECT 
    'bot_message_templates' AS table_name,
    COUNT(*) AS count
FROM bot_message_templates;

-- 2. عرض البيانات
-- ============================================
SELECT 'Showing message_templates data...' AS step;
SELECT `key`, LEFT(text, 50) as preview FROM message_templates LIMIT 5;

SELECT 'Showing limit_messages data...' AS step;
SELECT event, LEFT(text, 50) as preview FROM limit_messages;

-- 3. التحقق من البنية
-- ============================================
SELECT 'Checking structure...' AS step;

SHOW COLUMNS FROM message_templates;
SHOW COLUMNS FROM limit_messages;
SHOW COLUMNS FROM bot_message_templates;

-- ============================================
-- النتيجة المتوقعة:
-- ============================================
-- • message_templates: يجب أن يحتوي على 7+ صفوف
-- • limit_messages: يجب أن يحتوي على 3+ صفوف
-- • bot_message_templates: 0 صفوف (فارغ - هذا طبيعي)
-- ============================================
