# 📦 Archived Project Files

**Archived Date:** 2025-10-24  
**Reason:** Project cleanup - Removed unused/dead assets  
**Original Location:** C:\Users\222222222qqqqqqqq\Downloads\bott111\

---

## 📂 Archive Structure

```
archive_unused/
├── docs/          # Documentation files (.md, .txt)
├── tests/         # Test and diagnostic files
├── db_dumps/      # Old SQL dumps (not current)
├── backups/       # Backup PHP versions
├── installer/     # Post-install updater system
├── snippets/      # Code fragments/patches
└── logs/          # Log files
```

---

## ⚠️ What's Archived

### Documentation (69 files)
- AI-generated analysis reports
- Installation/fix guides (already applied)
- Troubleshooting docs (issues resolved)
- README variations
- System diagrams and flows

### Test/Debug Files (15 files)
- `test_*.php` - Testing scripts
- `debug_*.php` - Debug utilities
- `diagnose_*.php` - Diagnostic tools
- `verify_*.php` - Verification scripts

### Database Dumps (20 files)
- Old SQL schemas
- Test SQL files
- Fix SQL scripts (already applied)
- **NOTE:** Current DB is in `sql/finalsql/supehgku_test0.sql` (NOT archived)

### Backup Versions (6 files)
- `sub_bot_backup_*.php`
- `sub_bot_debug.php`
- `sub_bot_final.php`
- `sub_bot_minimal.php`
- `sub_bot_with_debug.php`
- `sub_bot_limits_patch.php`

### Installer/Updater (Full directory)
- `updates/` directory (post-install artifacts)
- `install_*.php` scripts (one-time use)

### Code Snippets (4 files)
- `NEW_GROUP_COMMANDS.php`
- `limits_commands_part*.php`
- `apply_patch.php`

### Logs (2 files)
- `error_log`
- `minimal_log.txt`

---

## ✅ What's NOT Archived (Still Active)

### Critical Runtime Files:
```
.env.php
control_bot.php
sub_bot.php
cron_limits_maintenance.php
lib/telegram.php
lib/steam.php
lib/limits_core.php
lib/limits.php
lib/help_content.php
sql/finalsql/supehgku_test0.sql (current DB backup)
```

---

## 🔄 How to Restore

If you need to restore any archived file:

1. **Individual File:**
   ```powershell
   Copy-Item archive_unused/[category]/[filename] .
   ```

2. **Full Category:**
   ```powershell
   Copy-Item archive_unused/docs/* . -Recurse
   ```

3. **Complete Rollback (Git):**
   ```powershell
   git checkout pre-cleanup-2025-10-24
   ```

---

## 🗑️ Safe to Delete?

**YES** - This entire `archive_unused/` directory can be safely deleted if:
- System is working correctly
- No need for historical documentation
- Database backup exists elsewhere
- Git history is preserved

**Before deleting, confirm:**
- [ ] Webhooks (control_bot.php, sub_bot.php) working
- [ ] Database connection active
- [ ] Steam codes generating correctly
- [ ] Limits system functioning

---

## 📊 Space Saved

- **Before Cleanup:** ~1.6 MB (161 files)
- **After Cleanup:** ~150 KB (9 critical files)
- **Archived:** ~1.45 MB (116 files)
- **Space Saved:** ~90%

---

**End of Archive README**
