﻿-- ============================================
-- تحديث قائمة /help في قاعدة البيانات
-- ============================================
-- التاريخ: 2025-10-25
-- الغرض: تحديث أوامر المجموعات والقسائم الجديدة
-- ============================================

-- تحديث قسم المجموعات (help_part4)
UPDATE message_templates 
SET text = '📂 <b>قسم المجموعات</b> (النظام الجديد) ✨

💡 <i>نظام متطور لتجميع الحسابات وربطها بالبوتات</i>

<b>📋 إدارة المجموعات:</b>
<b>/group_add</b> <code>name</code> - إنشاء مجموعة جديدة
💡 <code>/group_add vip</code>

<b>/group_rename</b> <code>old new</code> - إعادة تسمية 🆕
💡 <code>/group_rename vip premium</code>

<b>/group_delete</b> <code>name confirm</code> - حذف نهائي 🆕
💡 <code>/group_delete old confirm</code>

<b>/group_lock</b> <code>name</code> - قفل (منع rename/delete) 🆕
<b>/group_unlock</b> <code>name</code> - فتح القفل 🆕

<b>/groups_list</b> - عرض جميع المجموعات
💡 يعرض المجموعات مع عداد البوتات والحسابات

<b>/group_info</b> <code>group</code> - تفاصيل مجموعة
💡 <code>/group_info default</code>

<b>/group_toggle</b> <code>group</code> - تفعيل/تعطيل
💡 <code>/group_toggle vip</code>

<b>/group_usage</b> <code>group</code> - إحصائيات الاستخدام 🆕
💡 <code>/group_usage vip</code>

<b>🤖 ربط البوتات:</b>
<b>/group_bind</b> <code>bot group</code> - ربط بوت بمجموعة
💡 <code>/group_bind mybot vip</code>

<b>/group_unbind</b> <code>bot group</code> - فك ربط بوت
💡 <code>/group_unbind mybot vip</code>

<b>/bot_groups</b> <code>bot</code> - عرض مجموعات وحسابات بوت 🆕
💡 <code>/bot_groups mybot</code>

<b>👤 إدارة الحسابات (دفعات):</b>
<b>/group_account_add</b> <code>group acc1 acc2 ...</code> 🆕
➡️ إضافة حسابات لمجموعة (دفعة واحدة)
💡 <code>/group_account_add vip acc1 acc2 acc3</code>

<b>/group_account_del</b> <code>group acc1 acc2 ...</code> 🆕
➡️ إزالة حسابات من مجموعة (دفعة واحدة)
💡 <code>/group_account_del vip acc1 acc2</code>

⚠️ <i>البوت يرى فقط الحسابات الموجودة في مجموعاته</i>'
WHERE `key` = 'help_part4';

-- ============================================

-- تحديث قسم القسائم (help_part5)
UPDATE message_templates 
SET text = '🎫 <b>قسم القسائم</b> 🆕

💡 <i>لزيادة حدود المستخدمين أو إضافة أيام</i>

<b>/generate_voucher</b> <code>type amount [bot] [uses]</code>
➡️ إنشاء قسيمة جديدة

<b>الأنواع:</b> users | days

💡 <code>/generate_voucher users 100 mybot 1</code>
💡 <code>/generate_voucher users 50 all 5</code>

<b>/redeem</b> <code>code [bot]</code> - تفعيل قسيمة
💡 <code>/redeem ABC123 mybot</code>

<b>/vouchers</b> - عرض جميع القسائم
<b>/voucher_search</b> <code>code</code> - بحث عن قسيمة

<b>/voucher_who_used</b> <code>code</code> - تقرير الاستخدام 🆕
💡 <code>/voucher_who_used ABC123</code>
➡️ يعرض البوتات التي استخدمت القسيمة مع التواريخ'
WHERE `key` = 'help_part5';

-- ============================================
-- التحقق من التحديث
-- ============================================
SELECT 
    `key`, 
    LEFT(text, 100) as preview,
    CHAR_LENGTH(text) as length
FROM message_templates 
WHERE `key` IN ('help_part4', 'help_part5');

-- ============================================
SELECT '✅ تم تحديث قائمة /help بنجاح!' AS status;
