# 🔍 حل المشاكل - Troubleshooting

## ❌ المشكلة: `/responses` لا يظهر شيء

### الأسباب المحتملة:

#### 1️⃣ لم يتم تطبيق SQL
**التشخيص:**
```sql
SELECT COUNT(*) FROM message_templates;
-- النتيجة المتوقعة: 7 أو أكثر
```

**الحل:**
```bash
mysql -u username -p database_name < sql/supehgku_test0.sql
```

---

#### 2️⃣ لم يتم رفع `control_bot.php` المُحدّث
**التشخيص:**
- افتح `control_bot.php` على السيرفر
- ابحث عن السطر 397
- يجب أن يحتوي على:
```php
case '/responses': {
    $rows = $db->query("SELECT `key`,`text` FROM message_templates...
```

**الحل:**
```bash
scp control_bot.php user@server:/path/control_bot.php
```

---

#### 3️⃣ الجدول فارغ
**التشخيص:**
```sql
SELECT * FROM message_templates;
-- إذا كان فارغاً:
```

**الحل:**
```sql
-- أضف بيانات يدوياً:
INSERT INTO message_templates (`key`, text) VALUES
('start_1', 'مرحباً بك!'),
('code_reply', '🔐 الحساب: {account}\nالكود: <code>{code}</code>');
```

---

#### 4️⃣ خطأ في الاتصال بقاعدة البيانات
**التشخيص:**
- تحقق من ملف `.env` أو `config.php`
- تأكد من صحة بيانات الاتصال

**الحل:**
```php
// في .env أو config.php
DB_HOST=localhost
DB_NAME=database_name
DB_USER=username
DB_PASS=password
```

---

## ❌ المشكلة: `/msg_show` لا يظهر شيء

### الأسباب المحتملة:

#### 1️⃣ الجدول غير موجود أو فارغ
**التشخيص:**
```sql
SELECT COUNT(*) FROM limit_messages;
-- النتيجة المتوقعة: 3 أو أكثر
```

**الحل:**
```sql
-- إذا كان الجدول فارغاً:
INSERT INTO limit_messages (event, text) VALUES
('on_limit_hit', '⏳ لقد استهلكت حدك اليومي'),
('on_banned', '🚫 تم حظرك مؤقتاً'),
('on_daily_near', '⚠️ تنبيه: اقتربت من حدك');
```

---

#### 2️⃣ الأمر غير موجود في control_bot.php
**التشخيص:**
```bash
grep "case '/msg_show':" control_bot.php
# يجب أن يظهر السطر 2287
```

**الحل:**
- ارفع `control_bot.php` المُحدّث من المشروع

---

## 🧪 اختبار سريع

### الطريقة 1: SQL
```bash
mysql -u username -p database_name < TEST_COMMANDS.sql
```

### الطريقة 2: يدوي
```sql
-- تسجيل الدخول
mysql -u username -p database_name

-- التحقق من message_templates
SELECT COUNT(*) FROM message_templates;
SELECT `key` FROM message_templates;

-- التحقق من limit_messages
SELECT COUNT(*) FROM limit_messages;
SELECT event FROM limit_messages;

-- التحقق من bot_message_templates
SHOW TABLES LIKE 'bot_message_templates';
```

---

## ✅ الحل الشامل (خطوة بخطوة)

### الخطوة 1: التحقق من قاعدة البيانات

```bash
mysql -u username -p database_name -e "SELECT COUNT(*) as c FROM message_templates"
```

**إذا كانت النتيجة 0 أو ERROR:**
```bash
# طبّق SQL كامل
mysql -u username -p database_name < sql/supehgku_test0.sql
```

---

### الخطوة 2: التحقق من control_bot.php على السيرفر

```bash
# على السيرفر
grep -n "case '/responses':" control_bot.php
grep -n "case '/msg_show':" control_bot.php
```

**إذا لم يظهر شيء:**
```bash
# ارفع الملف المُحدّث
scp control_bot.php user@server:/path/
```

---

### الخطوة 3: اختبر في البوت

```
/responses
/msg_show
```

---

## 📊 التحقق من الإصدار

### تحقق من أن control_bot.php محدّث:

**يجب أن يحتوي على:**
```php
// السطر ~397
case '/responses': {
    $rows = $db->query("SELECT `key`,`text` FROM message_templates ORDER BY `key` ASC")->fetchAll();
    if (!$rows) { 
        tg_send($CONTROL_TOKEN, $chat_id, "❌ لا توجد ردود عامة مخزنة.");
```

```php
// السطر ~2287
case '/msg_show': {
    $stmt = $db->query("SELECT event, text FROM limit_messages ORDER BY event");
```

**وأيضاً يجب أن يحتوي على الأوامر الجديدة:**
```php
// السطر ~443
case '/edit_global_response': {

// السطر ~481
case '/edit_bot_response': {
```

---

## 🔧 إصلاح سريع

### إذا كانت المشكلة في البيانات:

```sql
-- أضف بيانات message_templates
INSERT INTO message_templates (`key`, text) VALUES
('start_1', '🎉 مرحباً بك في نظام Steam Guard!\n\nلطلب كود، أرسل اسم الحساب فقط.'),
('start_2', '✅ تم التحقق من اشتراكك في القناة!\n\nيمكنك الآن طلب الأكواد 🔐'),
('code_reply', '🔐 الحساب: {account}\nالكود: <code>{code}</code>\n⏳ صالح لمدة ~30 ثانية.'),
('invalid_account', '❌ الحساب "{account}" غير موجود أو غير نشط.'),
('rate_limited', '⏳ لقد تجاوزت الحد المسموح. يرجى المحاولة لاحقاً.'),
('paused', '⏸️ البوت متوقف مؤقتاً. يرجى المحاولة لاحقاً.'),
('no_accounts', '❌ لا توجد حسابات متاحة حالياً.');

-- أضف بيانات limit_messages
INSERT INTO limit_messages (event, text) VALUES
('on_limit_hit', '⏳ لقد استهلكت حدك اليومي ({day_used}/{per_day}) للحساب {account}.\n\n🔄 إعادة التعيين: {reset_time}\n\n💡 تواصل مع المالك لزيادة حدودك.'),
('on_banned', '🚫 تم حظرك من الحساب {account} لمدة {ban_days} أيام.\n\n📅 الحظر ينتهي في: {banned_until}\n\nالسبب: تجاوزت الحد المسموح.'),
('on_daily_near', '⚠️ تنبيه: اقتربت من حدك اليومي!\n\n📊 الاستخدام: {day_used}/{per_day}\n💎 المتبقي: {remaining} طلبات\n🔄 إعادة التعيين: {reset_time}');
```

---

## 📝 ملاحظات

### ✅ الجداول الموجودة في SQL:
- `message_templates` - ✅ موجود مع بيانات
- `limit_messages` - ✅ موجود مع بيانات
- `bot_message_templates` - ✅ موجود (فارغ - طبيعي)

### ✅ الأوامر في control_bot.php:
- `/responses` - ✅ السطر 397
- `/msg_show` - ✅ السطر 2287
- `/edit_global_response` - ✅ السطر 443
- `/edit_bot_response` - ✅ السطر 481
- `/bot_responses` - ✅ السطر 526
- `/delete_bot_response` - ✅ السطر 582
- `/copy_global_to_bot` - ✅ السطر 614

---

## 🎯 الخلاصة

**الملفات صحيحة 100%!**

المشكلة المحتملة:
1. ❌ لم يتم رفع `control_bot.php` المُحدّث
2. ❌ لم يتم تطبيق SQL
3. ❌ خطأ في الاتصال بقاعدة البيانات

**الحل:**
```bash
# 1. طبّق SQL
mysql -u user -p database < sql/supehgku_test0.sql

# 2. ارفع PHP
scp control_bot.php user@server:/path/

# 3. اختبر
/responses
/msg_show
```

---

**إذا استمرت المشكلة، شغّل:**
```bash
mysql -u user -p database < TEST_COMMANDS.sql
```
