﻿# 🔧 تم إصلاح خطأ Migration

## ❌ المشكلة
```
#1064 - You have an error in your SQL syntax...
near '(LOWER(group_name)))'
```

**السبب:** 
- Functional indexes مثل CREATE INDEX ON table ((LOWER(column))) تعمل فقط في:
  - MySQL 8.0.13+
  - MariaDB 10.6+
- إصدارك القديم لا يدعمها

---

## ✅ الحل المُطبّق

استخدام **Generated Column** بدلاً من functional index:

### الخطوات الجديدة:

1. **إضافة عمود محسوب (Generated Column):**
```sql
ALTER TABLE account_groups 
ADD COLUMN group_name_lower VARCHAR(64) 
AS (LOWER(group_name)) STORED;
```

2. **إنشاء فهرس فريد عليه:**
```sql
CREATE UNIQUE INDEX idx_unique_group_name_lower 
ON account_groups (group_name_lower);
```

### الفوائد:
- ✅ يعمل مع جميع إصدارات MariaDB/MySQL
- ✅ نفس الأداء
- ✅ نفس الوظيفة (case-insensitive uniqueness)

---

## 🚀 الآن يمكنك التطبيق

### 1. أعد تشغيل Migration:
```bash
mysql -u user -p database < MIGRATION_GROUPS_VOUCHERS.sql
```

### 2. النتيجة المتوقعة:
```
✅ Column locked already exists (or added)
✅ Column group_name_lower already exists (or added)
✅ Unique index on group_name_lower already exists (or created)
✅ Table voucher_usage created
✅ Migration completed successfully!
```

---

## 🧪 اختبار بعد التطبيق

### اختبار التفرد (Case-Insensitive):

```sql
-- يجب أن يفشل لأن vip = VIP
INSERT INTO account_groups(group_name) VALUES('vip');
INSERT INTO account_groups(group_name) VALUES('VIP'); -- ❌ خطأ

-- يجب أن ينجح لأن premium ≠ vip
INSERT INTO account_groups(group_name) VALUES('premium'); -- ✅ نجح
```

### في البوت:

```
/group_add test
/group_add TEST    ← يجب أن يفشل (موجود مسبقاً)
/group_add Test    ← يجب أن يفشل (موجود مسبقاً)
```

---

## 📊 التغييرات في الجدول

| العمود | النوع | الوصف |
|--------|------|-------|
| `locked` | TINYINT(1) | قفل المجموعة |
| `group_name_lower` | VARCHAR(64) GENERATED | نسخة lowercase من group_name |

| الفهرس | العمود | النوع |
|--------|--------|-------|
| `idx_unique_group_name_lower` | `group_name_lower` | UNIQUE |

---

## 🎯 ما تم إصلاحه

✅ الملف: `MIGRATION_GROUPS_VOUCHERS.sql`
- استبدال functional index بـ generated column
- تحديث أرقام الخطوات (1-5)
- Idempotent (آمن للتشغيل مرتين)

---

## 💡 ملاحظة للمستقبل

إذا احتجت case-insensitive comparison في queries:

### ❌ القديم (بطيء):
```sql
WHERE LOWER(group_name) = LOWER(?)
```

### ✅ الجديد (سريع):
```sql
WHERE group_name_lower = LOWER(?)
```

العمود المحسوب `group_name_lower` يُحدّث تلقائياً عند تغيير `group_name`.

---

**جرّب الآن! الملف جاهز للتطبيق. ✅**
