-- ================================================================
-- إضافة bot_label إلى limit_bans لجعل الحظر مستقل لكل بوت
-- ================================================================
-- المشكلة: الحظر حالياً عام على جميع البوتات
-- الحل: إضافة bot_label
-- ================================================================

-- 1. عرض البنية الحالية
DESCRIBE limit_bans;

-- 2. حذف المفتاح الفريد القديم (إذا وُجد)
ALTER TABLE `limit_bans` 
DROP INDEX IF EXISTS `unique_user_account_ban`;

-- 3. إضافة عمود bot_label
ALTER TABLE `limit_bans` 
ADD COLUMN `bot_label` VARCHAR(50) NULL AFTER `account_id`,
ADD INDEX `idx_bot_ban` (`bot_label`);

-- 4. ملء bot_label للسجلات الموجودة (افتراضياً test1)
UPDATE `limit_bans` 
SET `bot_label` = 'test1' 
WHERE `bot_label` IS NULL;

-- 5. جعل bot_label إجباري
ALTER TABLE `limit_bans` 
MODIFY `bot_label` VARCHAR(50) NOT NULL COMMENT 'تسمية البوت';

-- 6. إضافة مفتاح فريد جديد (user_id, account_id, bot_label)
ALTER TABLE `limit_bans` 
ADD UNIQUE KEY `unique_user_account_bot_ban` (`user_id`, `account_id`, `bot_label`);

-- 7. إضافة foreign key لـ bot_label
ALTER TABLE `limit_bans`
ADD CONSTRAINT `fk_bans_bot` 
FOREIGN KEY (`bot_label`) 
REFERENCES `sub_bots`(`label`) 
ON UPDATE CASCADE 
ON DELETE CASCADE;

-- 8. التحقق من النتيجة
SHOW INDEX FROM `limit_bans`;

-- ================================================================
-- الآن الحظر مستقل لكل بوت:
-- - المستخدم محظور في test1 لكن ليس في test2
-- - حظر كل بوت منفصل عن الآخر
-- ================================================================
