# 🔧 إصلاح مشكلة أسماء البوتات الرقمية

**المشكلة:** استخدام أرقام كأسماء للبوتات يسبب تضارباً مع `account_id` في أمر `/show_limit`

---

## 📊 المشكلة الحالية

### البوتات الموجودة:
```
ID 27 → label = '1'
ID 28 → label = '2'
ID 29 → label = '3'
```

### المشكلة:
```bash
/show_limit 1  # ❌ يفسر كـ account_id وليس bot_label
```

---

## ✅ الحل السريع (بدون تغيير أسماء البوتات)

استخدم صيغة `bot/` في الأوامر:

```bash
# ❌ الخطأ:
/show_limit 1

# ✅ الصحيح:
/show_limit bot/1
```

### الأوامر الصحيحة:

```bash
# تعيين حد يومي
/set_daily 1 5             # ✅ يعمل

# عرض الحدود (استخدم صيغة bot/)
/show_limit bot/1          # ✅ صحيح
/show_limit 1              # ❌ يبحث عن account_id=1

# عرض جميع البوتات
/show_limit bot            # ✅ يعرض كل البوتات

# حذف الحدود
/bot_limit_clear 1         # ✅ يعمل
```

---

## 🔧 الحل الدائم (إعادة تسمية البوتات)

### SQL لإعادة التسمية:

```sql
-- إعادة تسمية البوتات إلى أسماء واضحة
UPDATE sub_bots SET label = 'test1' WHERE id = 27;
UPDATE sub_bots SET label = 'test2' WHERE id = 28;
UPDATE sub_bots SET label = 'test3' WHERE id = 29;

-- تحديث الحدود الموجودة
UPDATE limits_bot SET bot_label = 'test1' WHERE bot_label = '1';
UPDATE limits_bot SET bot_label = 'test2' WHERE bot_label = '2';
UPDATE limits_bot SET bot_label = 'test3' WHERE bot_label = '3';

-- تحديث bot_groups
UPDATE bot_groups bg 
JOIN sub_bots sb ON sb.id = bg.bot_id
SET bg.bot_label = sb.label
WHERE sb.id IN (27, 28, 29);
```

### بعد التحديث، استخدم:

```bash
# ✅ الآن ستعمل جميع الصيغ:
/set_daily test1 5
/show_limit test1          # ✅ يعمل بشكل مباشر
/show_limit bot/test1      # ✅ يعمل أيضاً
```

---

## 📝 الخلاصة

### السبب:
```php
// في control_bot.php، السطر ~2451:
if (is_numeric($target)) {
    // يعتبر $target = account_id
}
```

### الحل المؤقت:
- استخدم `/show_limit bot/1`
- **أو** `/show_limit 1` سيبحث في جدول `limits_override` (حدود الحسابات)

### الحل الدائم:
- أعد تسمية البوتات إلى أسماء غير رقمية: `test1`, `test2`, `test3`
- أو استخدم دائماً صيغة `bot/1` للوضوح

---

## ✅ التحقق من نجاح الحدود

بعد تطبيق `/set_daily 1 5`:

### تحقق في قاعدة البيانات:

```sql
SELECT * FROM limits_bot WHERE bot_label = '1';
```

**النتيجة المتوقعة:**
```
bot_label | mode  | per_day | weekly_cap | monthly_cap | ban_days
'1'       | daily | 5       | NULL       | NULL        | NULL
```

### تحقق في Telegram:

```bash
# استخدم الصيغة الصحيحة:
/show_limit bot/1
```

**النتيجة المتوقعة:**
```
🤖 حدود البوت: 1

✅ حدود خاصة:

📊 الوضع: يومي
📅 الحد اليومي: 5 كود
🚫 مدة الحظر: بدون حظر

💡 لحذف الحدود الخاصة: /bot_limit_clear 1
```

---

## 🎯 اختبار في البوت الفرعي

بعد تطبيق الحدود، اختبر:

```bash
# في البوت الفرعي (test1):
wastefulstupidlapwing  # المرة 1 → ✅ كود
wastefulstupidlapwing  # المرة 2 → ✅ كود
wastefulstupidlapwing  # المرة 3 → ✅ كود
wastefulstupidlapwing  # المرة 4 → ✅ كود
wastefulstupidlapwing  # المرة 5 → ✅ كود
wastefulstupidlapwing  # المرة 6 → ❌ رفض (تجاوز الحد)
```

**يجب أن يُرفض بعد 5 محاولات في اليوم!**

---

## 🚨 ملاحظة مهمة

إذا كان البوت لا يزال يستخدم الحدود العامة (1000 يوم حظر)، تحقق:

1. **تأكد أن الحدود مُضافة:**
   ```sql
   SELECT * FROM limits_bot WHERE bot_label = '1';
   ```

2. **تأكد من اسم البوت في قاعدة البيانات:**
   ```sql
   SELECT id, label FROM sub_bots WHERE id = 27;
   ```

3. **تأكد من تطابق الاسم:**
   - اسم البوت في `sub_bots.label` = `'1'`
   - اسم البوت في `limits_bot.bot_label` = `'1'`
   - يجب أن يتطابقا تماماً!

---

*آخر تحديث: 2025-10-25*
