# 🚀 تعليمات الترحيل - نقل البيانات من القديم إلى الجديد

## 📊 ملخص التحليل

### ✅ قاعدة البيانات القديمة (supehgku_Packagemaker)
- **6 جداول** فقط
- **102 حساب Steam**
- **26 بوت**
- **359 مستخدم**
- **3,412 طلب**

### ✅ قاعدة البيانات الجديدة (supehgku_test0)
- **23 جدول** (17 جدول جديد)
- نظام مجموعات
- نظام حدود متقدم
- نظام قسائم
- نظام بث

---

## 🔍 المشاكل المكتشفة

### 1️⃣ **sub_bots.daily_attempts** ❌ حرجة
**المشكلة:**
```sql
-- القديم
daily_attempts int(11) DEFAULT 5

-- الجديد
غير موجود (نُقل إلى limits_bot)
```

**الحل:**
```sql
-- بعد ترحيل sub_bots
INSERT INTO limits_bot (bot_label, mode, per_day, per_week, per_month)
SELECT label, 'daily', daily_attempts, daily_attempts * 7, daily_attempts * 30
FROM old_db.sub_bots;
```

### 2️⃣ **أعمدة خاطئة في نظام الترحيل القديم** ❌
**الكود القديم يحاول نقل:**
```php
'current_users'  // ❌ غير موجود في القديم
'paused'         // ❌ خطأ، الصحيح: is_paused
```

**التصحيح:**
```php
['id', 'label', 'bot_token', 'channel_id', 'max_users', 
 'is_paused', 'welcome_message', 'created_at', 'updated_at']
```

### 3️⃣ **control_sessions معطل** ⚠️
في `migration_config.ini`:
```ini
control_sessions = 0  # معطل
```

**الحل:** تفعيله أو ترحيله يدوياً

---

## 📋 خطة الترحيل المُصححة

### المرحلة 0: التحضير
```sql
-- إنشاء المجموعة الافتراضية
INSERT INTO account_groups (id, group_name, description, is_default, locked, active)
VALUES (1, 'default', 'المجموعة العامة', 1, 1, 1);

-- تعطيل Foreign Keys
SET FOREIGN_KEY_CHECKS=0;
```

### المرحلة 1: البيانات الأساسية

#### 1.1 sub_bots ✅ مُصحّح
```sql
INSERT IGNORE INTO supehgku_test0.sub_bots 
(id, label, bot_token, channel_id, max_users, is_paused, force_subscription, welcome_message, created_at, updated_at)
SELECT 
    id, label, bot_token, channel_id, max_users, is_paused,
    1 AS force_subscription,  -- افتراضي جديد
    welcome_message, created_at, updated_at
FROM supehgku_Packagemaker.sub_bots;
```

#### 1.2 steam_accounts ✅
```sql
INSERT IGNORE INTO supehgku_test0.steam_accounts 
SELECT * FROM supehgku_Packagemaker.steam_accounts;
```

#### 1.3 allowed_users ✅
```sql
INSERT IGNORE INTO supehgku_test0.allowed_users 
SELECT * FROM supehgku_Packagemaker.allowed_users;
```

#### 1.4 message_templates ✅
```sql
INSERT INTO supehgku_test0.message_templates 
SELECT * FROM supehgku_Packagemaker.message_templates
ON DUPLICATE KEY UPDATE text = VALUES(text);
```

#### 1.5 control_sessions ✅
```sql
INSERT IGNORE INTO supehgku_test0.control_sessions 
SELECT * FROM supehgku_Packagemaker.control_sessions;
```

### المرحلة 2: نقل daily_attempts ✅ جديد
```sql
INSERT INTO limits_bot (bot_label, mode, per_day, per_week, per_month, ban_duration)
SELECT 
    label,
    'daily' AS mode,
    daily_attempts AS per_day,
    daily_attempts * 7 AS per_week,
    daily_attempts * 30 AS per_month,
    1 AS ban_duration
FROM supehgku_Packagemaker.sub_bots
ON DUPLICATE KEY UPDATE
    per_day = VALUES(per_day),
    per_week = VALUES(per_week),
    per_month = VALUES(per_month);
```

### المرحلة 3: الربط

#### 3.1 ربط الحسابات بالمجموعة الافتراضية
```sql
INSERT IGNORE INTO group_accounts (group_id, account_id)
SELECT 1, id FROM steam_accounts;
```

#### 3.2 ربط البوتات بالمجموعة الافتراضية
```sql
INSERT IGNORE INTO bot_groups (bot_id, group_id)
SELECT id, 1 FROM sub_bots;
```

### المرحلة 4: البيانات الاختيارية

#### steam_requests ⚠️ (كبير جداً - معطل)
```sql
-- إذا أردت ترحيله (3,412 سجل):
INSERT IGNORE INTO supehgku_test0.steam_requests 
SELECT * FROM supehgku_Packagemaker.steam_requests;
```

### المرحلة 5: التنظيف

#### إعادة Foreign Keys
```sql
SET FOREIGN_KEY_CHECKS=1;
```

#### تحديث AUTO_INCREMENT
```sql
ALTER TABLE sub_bots AUTO_INCREMENT = 27;
ALTER TABLE steam_accounts AUTO_INCREMENT = 103;
ALTER TABLE allowed_users AUTO_INCREMENT = 360;
ALTER TABLE control_sessions AUTO_INCREMENT = 27;
```

#### التحقق
```sql
-- التحقق من الحسابات اليتيمة
SELECT COUNT(*) FROM steam_accounts sa
LEFT JOIN group_accounts ga ON ga.account_id = sa.id
WHERE ga.account_id IS NULL;
-- يجب أن يكون: 0

-- التحقق من البوتات اليتيمة
SELECT COUNT(*) FROM sub_bots sb
LEFT JOIN bot_groups bg ON bg.bot_id = sb.id
WHERE bg.bot_id IS NULL;
-- يجب أن يكون: 0
```

---

## 🛠️ الخيارات المتاحة

### الخيار 1: سكريبت PHP مُصحّح ✅ موصى به
- ملف `MIGRATION_FIXED.php` محسّن
- يعمل بـ Dry Run أولاً
- يسجل كل شيء
- آمن للإعادة

**الاستخدام:**
```bash
# 1. اختبار أولاً
php MIGRATION_FIXED.php
# سيعمل بـ Dry Run افتراضياً

# 2. تنفيذ حقيقي
# عدّل: $CONFIG['settings']['dry_run'] = false;
php MIGRATION_FIXED.php
```

### الخيار 2: SQL يدوي مباشر
استخدم الاستعلامات أعلاه مباشرة في phpMyAdmin/MySQL

### الخيار 3: تصحيح نظام الترحيل القديم
تعديل `ARCHIVE_DOCS/old_migrations/migration_system/scripts/migrate.php`

---

## ⚠️ تحذيرات مهمة

### قبل البدء
1. ✅ **نسخة احتياطية كاملة**
   ```bash
   mysqldump -u root supehgku_test0 > backup_$(date +%Y%m%d).sql
   ```

2. ✅ **اختبار على قاعدة تجريبية**
   ```sql
   CREATE DATABASE supehgku_test0_staging LIKE supehgku_test0;
   ```

3. ✅ **تحقق من المساحة**
   - القاعدة القديمة: ~500 KB
   - القاعدة الجديدة: ~70 KB
   - الإجمالي بعد الترحيل: ~600 KB

### الأعمدة الجديدة (ستكون NULL)
في `sub_bots`:
- `owner_name`
- `owner_birthdate`
- `owner_store_page`
- `owner_phone`
- `owner_whatsapp`
- `owner_second_phone`
- `owner_notes`

يمكن ملؤها لاحقاً من control_bot

### steam_requests
- **3,412 سجل** (كبير)
- معطل افتراضياً
- لترحيله: فعّله في الإعدادات

---

## 📊 النتيجة المتوقعة

```
✅ sub_bots: 26 بوت
✅ steam_accounts: 102 حساب
✅ allowed_users: 359 مستخدم
✅ message_templates: ~96 قالب
✅ control_sessions: 26 جلسة
✅ limits_bot: 26 بوت (من daily_attempts)
✅ group_accounts: 102 ربط
✅ bot_groups: 26 ربط

⏱️ الوقت المتوقع: أقل من 10 ثواني
💾 المساحة: ~600 KB
```

---

## 🚦 حالة الاستعداد

| المكون | الحالة | ملاحظات |
|--------|--------|---------|
| قاعدة المصدر | ✅ جاهز | supehgku_Packagemaker |
| قاعدة الهدف | ✅ جاهز | supehgku_test0 |
| نظام الترحيل | ⚠️ يحتاج تصحيح | 3 مشاكل |
| التوثيق | ✅ جاهز | DATABASE_ANALYSIS.md |
| النسخ الاحتياطي | ⚠️ مطلوب | قبل التنفيذ |

---

## 🎯 الخطوات التالية

### 1. اختبار بـ Dry Run
```bash
# افتح MIGRATION_FIXED.php
# تأكد: $CONFIG['settings']['dry_run'] = true
php MIGRATION_FIXED.php
```

### 2. مراجعة النتائج
- راجع ملف السجل
- تحقق من العدادات
- تأكد من عدم وجود أخطاء

### 3. التنفيذ الحقيقي
```bash
# عدّل: dry_run = false
php MIGRATION_FIXED.php
```

### 4. التحقق النهائي
```sql
-- عدد البوتات
SELECT COUNT(*) FROM sub_bots;  -- يجب: 26

-- عدد الحسابات
SELECT COUNT(*) FROM steam_accounts;  -- يجب: 102

-- الحدود
SELECT COUNT(*) FROM limits_bot;  -- يجب: 26

-- الربط
SELECT COUNT(*) FROM group_accounts WHERE group_id=1;  -- يجب: 102
SELECT COUNT(*) FROM bot_groups WHERE group_id=1;  -- يجب: 26
```

---

## 📞 الدعم

في حالة وجود مشاكل:
1. راجع `logs/migration_*.log`
2. راجع `DATABASE_ANALYSIS.md`
3. اختبر الاستعلامات يدوياً

---

**الحالة:** ✅ جاهز للترحيل بعد التصحيحات  
**التاريخ:** 25 أكتوبر 2025  
**الإصدار:** 2.0 (مُصحّح)
