-- نظام حدود المستخدمين (User-Level Limits)
-- أولوية أعلى من حدود البوت والحدود العامة

CREATE TABLE IF NOT EXISTS `limits_user` (
  `id` BIGINT(20) PRIMARY KEY AUTO_INCREMENT,
  `user_id` BIGINT(20) NOT NULL,
  `bot_label` VARCHAR(64) DEFAULT NULL,
  `mode` ENUM('daily','weekly','monthly') NOT NULL DEFAULT 'daily',
  `per_day` INT(11) NOT NULL DEFAULT 2,
  `weekly_cap` INT(11) DEFAULT NULL,
  `monthly_cap` INT(11) DEFAULT NULL,
  `ban_days` INT(11) DEFAULT NULL,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY `unique_user_bot` (`user_id`, `bot_label`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- إضافة فهارس للأداء
CREATE INDEX idx_user_limits_user ON `limits_user`(`user_id`);
CREATE INDEX idx_user_limits_bot ON `limits_user`(`bot_label`);

-- ترتيب الأولويات الجديد:
-- 1. limits_override (لحساب معين) ← أعلى أولوية
-- 2. limits_user (لمستخدم معين) ← أولوية جديدة
-- 3. limits_bot (لبوت معين)
-- 4. limits_global (للجميع) ← أقل أولوية
