-- إضافة دعم المجموعات في نظام القسائم
-- يجب تنفيذ هذا SQL قبل استخدام القسائم المرتبطة بالمجموعات

-- إضافة حقل target_group_id إلى جدول vouchers
ALTER TABLE `vouchers` 
ADD COLUMN `target_group_id` INT(11) DEFAULT NULL AFTER `target_label`,
ADD FOREIGN KEY (`target_group_id`) REFERENCES `account_groups`(`id`) ON DELETE SET NULL;

-- إضافة فهرس للأداء
CREATE INDEX idx_vouchers_group ON `vouchers`(`target_group_id`);

-- ملاحظة: القسيمة يمكن أن تكون:
-- 1. لجميع البوتات: target_label = NULL AND target_group_id = NULL
-- 2. لبوت معين: target_label = 'bot1' AND target_group_id = NULL
-- 3. لمجموعة معينة: target_label = NULL AND target_group_id = 5
