# تقرير نظام المجموعات (Groups System)

## 📋 نظرة عامة

نظام المجموعات يتيح **تنظيم الحسابات** وربطها بالبوتات بطريقة مرنة. كل بوت يرى فقط الحسابات الموجودة في مجموعاته.

**الهدف الرئيسي**: عزل الحسابات حسب الفئة أو الخطة

**الأمثلة**:
- مجموعة "36k" → حسابات بحد 36,000
- مجموعة "100k" → حسابات بحد 100,000
- مجموعة "200k" → حسابات بحد 200,000
- مجموعة "default" → المجموعة العامة

---

## 🗂️ الجداول المستخدمة

### 1. `account_groups` - المجموعات
### 2. `bot_groups` - ربط البوتات بالمجموعات
### 3. `group_accounts` - ربط الحسابات بالمجموعات

---

## 🔗 العلاقات

```
sub_bots ←→ bot_groups ←→ account_groups ←→ group_accounts ←→ steam_accounts
```

**المعنى**: البوت يرى فقط الحسابات الموجودة في مجموعاته

---

## 🏗️ الأوامر المتاحة

| الأمر | الوظيفة | السطر |
|-------|---------|-------|
| `/group_add <name>` | إنشاء مجموعة جديدة | 1282 |
| `/group_bind <bot> <group>` | ربط بوت بمجموعة | 1304 |
| `/group_unbind <bot> <group>` | فصل بوت عن مجموعة | 1341 |
| `/group_info <group>` | معلومات عن مجموعة | 1374 |
| `/group_account_add <group> <acc>...` | إضافة حسابات | 1446 |

---

## 🔍 آلية العمل في البوتات الفرعية

**الملف**: `sub_bot.php` السطر 649

```php
SELECT a.* 
FROM steam_accounts a
JOIN group_accounts ga ON ga.account_id = a.id
JOIN bot_groups bg ON bg.group_id = ga.group_id
WHERE bg.bot_id = ? AND a.account_name = ?
```

**النتيجة**: البوت يرى فقط الحسابات في مجموعاته

---

## 🎯 حالات الاستخدام

### مثال: تقسيم حسب الخطة

```bash
# إنشاء المجموعات
/group_add 36k
/group_add 100k

# إضافة الحسابات
/group_account_add 36k acc1 acc2 acc3
/group_account_add 100k acc6 acc7 acc8

# ربط البوتات
/group_bind bot_basic 36k
/group_bind bot_premium 100k
```

**النتيجة**:
- مستخدمو bot_basic يرون فقط acc1, acc2, acc3
- مستخدمو bot_premium يرون فقط acc6, acc7, acc8

---

## ⚙️ الميزات

- ✅ Many-to-Many (بوت واحد → عدة مجموعات)
- ✅ عزل كامل بين البوتات
- ✅ تفعيل/تعطيل المجموعات (`active`)
- ⚠️ المجموعة الافتراضية (غير مطبق)
- ⚠️ قفل المجموعة (غير مطبق)
- ⚠️ الأولوية (غير مطبق)

---

## ⚠️ المشاكل

1. **لا يوجد `/groups_list`** - لعرض جميع المجموعات
2. **الاستعلام معقد** - قد يكون بطيئاً مع بيانات كبيرة
3. **رسالة خطأ عامة** - لا تميز بين حساب غير موجود وحساب خارج المجموعة

---

## 🎯 الخلاصة

نظام مرن وقوي لتنظيم الحسابات. يعمل بشكل ممتاز لحالة الاستخدام الحالية (تقسيم حسب الخطة).
