# تقرير أوامر الإدارة (Commands Overview)

## 📋 نظرة عامة

**إجمالي الأوامر**: 100+ أمر

**تصنيف الأوامر**:
- أوامر بوت التحكم المركزي: ~80 أمر
- أوامر البوتات الفرعية (للمدراء): ~20 أمر

---

## 🎛️ أوامر بوت التحكم المركزي (Control Bot)

**الملف**: `control_bot.php`

**من يستطيع استخدامها**: المالك فقط (`OWNER_USER_ID`)

---

### 1️⃣ قسم إدارة البوتات (Bots Management)

| الأمر | الوظيفة | الملف/السطر |
|-------|---------|------------|
| `/addbot <label> <token> [ch] [max]` | إضافة بوت جديد | control_bot.php:147 |
| `/list` | عرض جميع البوتات | control_bot.php:176 |
| `/bot_rename <old> <new>` | تعديل اسم بوت | control_bot.php:? |
| `/pause <label>` | إيقاف بوت مؤقتاً | control_bot.php:191 |
| `/resume <label>` | تشغيل بوت متوقف | control_bot.php:191 |
| `/setmax <label> <n>` | تحديد الحد الأقصى للمستخدمين | control_bot.php:202 |
| `/incmax <label> <delta>` | زيادة الحد الأقصى | control_bot.php:210 |
| `/setchannel <label> <ch_id>` | تعيين قناة الاشتراك | control_bot.php:234 |
| `/settoken <label> <token>` | تحديث التوكن | control_bot.php:242 |
| `/setwelcome <label> <text>` | تحديث رسالة الترحيب | control_bot.php:257 |
| `/bot_details <label>` | معلومات تفصيلية عن بوت | control_bot.php:? |
| `/refreshbot <label>` | تحديث Webhook | control_bot.php:758 |
| `/deletebot <label> confirm` | حذف بوت نهائياً | control_bot.php:735 |

#### مثال: إضافة بوت

```bash
/addbot mybot 123456:ABC-token @mychannel 100
```

**الخطوات**:
1. إدراج في `sub_bots`
2. إنشاء Session لانتظار رسالة الترحيب (`await_welcome`)
3. إرسال رابط Webhook للتفعيل

---

### 2️⃣ قسم إدارة المستخدمين (Users Management)

| الأمر | الوظيفة | الملف/السطر |
|-------|---------|------------|
| `/users <label>` | مستخدمو بوت معين (آخر 200) | control_bot.php:266 |
| `/allusers` | جميع المستخدمين (آخر 500) | control_bot.php:285 |
| `/ban <user_id> [label]` | حظر مستخدم من بوت | control_bot.php:293 |
| `/unban <user_id> [label]` | إلغاء حظر مستخدم | control_bot.php:293 |
| `/checkuser <user_id>` | نشاط المستخدم | control_bot.php:310 |
| `/reset_limits <user_id>` | إعادة ضبط المحاولات | control_bot.php:? |

**ملاحظة مهمة**: 
- `/users` و `/allusers` يعانيان من **مشكلة الطول** (سنذكرها في known_issues.md)

---

### 3️⃣ قسم الحسابات (Accounts Management)

| الأمر | الوظيفة | الملف/السطر |
|-------|---------|------------|
| `/accounts` | عرض جميع الحسابات | control_bot.php:? |
| `/addaccount <name> <secret>` | إضافة حساب Steam | control_bot.php:? |
| `/addaccounts` | إضافة عدة حسابات دفعة واحدة | control_bot.php:? |
| `/deleteaccount <name>` | حذف حساب | control_bot.php:787 |
| `/toggle_account <name>` | تفعيل/تعطيل حساب | control_bot.php:? |
| `/account_info <name>` | معلومات عن حساب | control_bot.php:? |

#### مثال: إضافة حساب

```bash
/addaccount acc1 ABC123base64secret==
```

---

### 4️⃣ قسم المجموعات (Groups Management)

| الأمر | الوظيفة | الملف/السطر |
|-------|---------|------------|
| `/group_add <name>` | إنشاء مجموعة جديدة | control_bot.php:1282 |
| `/group_bind <bot_label> <group>` | ربط بوت بمجموعة | control_bot.php:1304 |
| `/group_unbind <bot_label> <group>` | فصل بوت عن مجموعة | control_bot.php:1341 |
| `/group_info <group>` | معلومات عن مجموعة | control_bot.php:1374 |
| `/group_account_add <group> <acc>...` | إضافة حسابات لمجموعة | control_bot.php:1446 |
| `/group_account_remove <group> <acc>` | إزالة حساب من مجموعة | control_bot.php:? |
| `/groups_list` | عرض جميع المجموعات | control_bot.php:? |

#### مثال: ربط بوت بمجموعة

```bash
/group_bind test1 36k
```

**النتيجة**: بوت "test1" يرى فقط الحسابات الموجودة في مجموعة "36k"

---

### 5️⃣ قسم نظام الحدود (Limits System) 🆕

| الأمر | الوظيفة | الملف/السطر |
|-------|---------|------------|
| `/set_daily_all <n>` | حد يومي عام للجميع | control_bot.php:? |
| `/limit_mode <bot> <mode>` | تعيين وضع حدود لبوت | control_bot.php:? |
| `/override_account <acc_id> <mode> <n>` | تجاوز حدود لحساب | control_bot.php:? |
| `/remove_override <acc_id>` | إزالة تجاوز الحدود | control_bot.php:? |
| `/show_limit <user_id> <acc_id>` | عرض حدود مستخدم | control_bot.php:? |
| `/reset_counters <user_id>` | إعادة تعيين عدادات | control_bot.php:? |
| `/ban_user <user> <acc> <days>` | حظر من حساب معين | control_bot.php:? |
| `/unban_user <user> <acc>` | إلغاء حظر | control_bot.php:? |

#### الأوضاع المتاحة:
- `daily`: حد يومي فقط
- `weekly`: حد يومي + أسبوعي (مع حظر عند التجاوز)
- `monthly`: حد يومي + شهري (مع حظر عند التجاوز)

#### مثال: تعيين حد لبوت

```bash
/limit_mode test1 weekly 3 7 5
```

**المعنى**: 
- وضع أسبوعي
- 3 أكواد يومياً
- 7 أكواد أسبوعياً
- حظر 5 أيام عند التجاوز

---

### 6️⃣ قسم القسائم (Vouchers System)

| الأمر | الوظيفة | الملف/السطر |
|-------|---------|------------|
| `/generate_voucher <type> <amt> [bot] [uses]` | إنشاء قسيمة | control_bot.php:877 |
| `/redeem <code> [bot]` | تفعيل قسيمة | control_bot.php:951 |
| `/vouchers` | عرض آخر 50 قسيمة | control_bot.php:1001 |
| `/voucher_search <code>` | البحث عن قسيمة | control_bot.php:1020 |
| `/voucher_delete <code>` | حذف قسيمة | control_bot.php:? |

#### أنواع القسائم:
- `users`: زيادة max_users
- `days`: (غير مفعل حالياً)

#### مثال: إنشاء قسيمة

```bash
/generate_voucher users 100 all 5
```

**المعنى**: قسيمة تضيف 100 مستخدم، لجميع البوتات، تستخدم 5 مرات

---

### 7️⃣ قسم البث (Broadcast System)

| الأمر | الوظيفة | الملف/السطر |
|-------|---------|------------|
| `/broadcast <label> <text>` | بث لمستخدمي بوت معين | control_bot.php:690 |
| `/broadcast_all <text>` | بث لجميع المستخدمين | control_bot.php:712 |

#### آلية العمل:

**في `/broadcast`**:
```
1. جلب bot_token من label
2. جلب مستخدمي هذا البوت (banned=0)
3. إرسال الرسالة لكل مستخدم
4. تأخير 200ms بين كل رسالة
5. عرض نتيجة (✅ نجح / ❌ فشل)
```

**في `/broadcast_all`**:
```
1. جلب جميع البوتات
2. لكل بوت:
   - جلب مستخدميه
   - إرسال الرسالة لكل مستخدم
3. تأخير 200ms
4. عرض إجمالي النتائج
```

---

### 8️⃣ قسم الردود والقوالب (Messages & Templates)

| الأمر | الوظيفة | الملف/السطر |
|-------|---------|------------|
| `/set_msg <key> <text>` | تحديث رسالة قالب | control_bot.php:? |
| `/get_msg <key>` | عرض رسالة قالب | control_bot.php:? |
| `/list_templates` | عرض جميع القوالب | control_bot.php:? |

#### قوالب متاحة:
- `start_1`, `start_2`: رسالة الترحيب
- `code_reply`: رد بعد إرسال الكود
- `paused`: رسالة البوت المتوقف
- `not_subscribed`: رسالة عدم الاشتراك
- `max_users_reached`: رسالة الوصول للحد الأقصى
- `on_limit_hit`: رسالة الوصول للحد اليومي
- `on_banned`: رسالة الحظر
- `on_daily_near`: تنبيه الاقتراب من الحد
- `on_share_warning`: تنبيه مشاركة الحساب

---

### 9️⃣ قسم المدراء الفرعيين (Sub-Managers)

| الأمر | الوظيفة | الملف/السطر |
|-------|---------|------------|
| `/add_manager <uid> <bot> <perms>` | إضافة مدير فرعي | control_bot.php:? |
| `/remove_manager <uid> <bot>` | إزالة مدير | control_bot.php:? |
| `/list_managers [bot]` | عرض المدراء | control_bot.php:? |
| `/manager_info <uid>` | معلومات عن مدير | control_bot.php:? |

#### الصلاحيات:

```
1 = بث (Broadcast)
2 = حظر (Ban)
3 = تعبئة قسائم (Redeem)
4 = عرض المستخدمين (View Users)
5 = البحث (Search)
6 = تعديل حدود (Modify Limits)
```

#### مثال:

```bash
/add_manager 123456789 test1 1:2:4
```

**المعنى**: مدير بصلاحيات البث والحظر وعرض المستخدمين في بوت "test1"

```bash
/add_manager 987654321 NULL all
```

**المعنى**: مدير عام بصلاحيات كاملة لجميع البوتات

---

### 🔟 قسم الإحصائيات (Statistics)

| الأمر | الوظيفة | الملف/السطر |
|-------|---------|------------|
| `/status` | حالة النظام العامة | control_bot.php:? |
| `/stats_today` | إحصائيات اليوم | control_bot.php:? |
| `/most_used_accounts` | أكثر الحسابات استخداماً | control_bot.php:? |

---

### 1️⃣1️⃣ قسم الصيانة (Maintenance)

| الأمر | الوظيفة | الملف/السطر |
|-------|---------|------------|
| `/cleanup_logs` | حذف السجلات القديمة | control_bot.php:? |
| `/run_maintenance` | تشغيل صيانة يدوياً | control_bot.php:? |
| `/backup_db` | نسخ احتياطي للقاعدة | control_bot.php:? |

---

### 1️⃣2️⃣ قسم المساعدة (Help System)

| الأمر | الوظيفة | الملف/السطر |
|-------|---------|------------|
| `/help` | عرض القائمة التفاعلية | control_bot.php:122 |

**آلية العمل**:
1. إرسال قائمة رئيسية بأزرار Inline
2. عند النقر على قسم، يتم عرض تفاصيله
3. القوائم مخزنة في `message_templates` (help_part1 إلى help_part9)

---

## 🤖 أوامر البوتات الفرعية (Sub Bot Commands)

**الملف**: `sub_bot.php`

**من يستطيع استخدامها**: المدراء الفرعيون فقط

---

### 1️⃣ الأوامر الأساسية

| الأمر | الصلاحية المطلوبة | الوظيفة | السطر |
|-------|-------------------|---------|-------|
| `/start` | الجميع | رسالة الترحيب | 83 |
| `/admin` | مدير | عرض قائمة الأوامر | 111 |

---

### 2️⃣ إدارة المستخدمين

| الأمر | الصلاحية | الوظيفة | السطر |
|-------|----------|---------|-------|
| `/users` | 4 | عرض آخر 100 مستخدم | 236 |
| `/search <uid>` | 5 | البحث عن مستخدم | 264 |
| `/ban <uid>` | 2 | حظر مستخدم | 302 |
| `/unban <uid>` | 2 | إلغاء حظر | 320 |
| `/top_users [n]` | 4 | أكثر المستخدمين نشاطاً | 338 |

---

### 3️⃣ نظام البث

| الأمر | الصلاحية | الوظيفة | السطر |
|-------|----------|---------|-------|
| `/broadcast <text>` | 1 | بث لجميع المستخدمين | 385 |
| `/broadcast_media` | 1 | بث مع وسائط (قيد التطوير) | 415 |
| `/broadcast_log` | 1 | سجل آخر 10 عمليات بث | 425 |

#### آلية `/broadcast` في البوتات الفرعية:

```
1. جلب مستخدمي البوت (DISTINCT user_id)
2. حلقة foreach على المستخدمين
3. إرسال الرسالة
4. تأخير 50ms (أسرع من بوت التحكم)
5. تسجيل في broadcast_log
6. عرض النتيجة
```

**⚠️ مشكلة معروفة**: يمكن أن يحدث تكرار غير منتهي (سنشرح في broadcast_system.md)

---

### 4️⃣ نظام القسائم

| الأمر | الصلاحية | الوظيفة | السطر |
|-------|----------|---------|-------|
| `/redeem <code>` | 3 | تفعيل قسيمة في البوت | 456 |
| `/vouchers_log` | 3 | سجل آخر 20 قسيمة | 496 |

---

### 5️⃣ الإحصائيات

| الأمر | الصلاحية | الوظيفة | السطر |
|-------|----------|---------|-------|
| `/mystats` | 4 | ملخص نشاط البوت | 527 |
| `/userstats <uid>` | 5 | إحصائيات مستخدم معين | 560 |
| `/codes_today` | 4 | عدد الأكواد اليوم | 601 |
| `/quota` | 4 | رصيد البوت (المستخدمون/الحد) | 616 |

---

## 📊 جدول مقارنة الأوامر

### البث (Broadcast)

| الميزة | بوت التحكم | البوتات الفرعية |
|--------|-----------|-----------------|
| الأمر | `/broadcast <label> <text>` | `/broadcast <text>` |
| من يستطيع | المالك فقط | المدير بصلاحية (1) |
| جلب المستخدمين | `SELECT user_id FROM allowed_users WHERE bot_token=?` | `SELECT DISTINCT user_id FROM allowed_users WHERE bot_token=?` |
| التأخير | 200ms | 50ms |
| التسجيل | ❌ لا يسجل | ✅ يسجل في `broadcast_log` |

---

### القسائم (Vouchers)

| الميزة | بوت التحكم | البوتات الفرعية |
|--------|-----------|-----------------|
| الأمر | `/redeem <code> [bot]` | `/redeem <code>` |
| من يستطيع | المالك فقط | المدير بصلاحية (3) |
| البوت المستهدف | يجب تحديده | البوت الحالي تلقائياً |
| التسجيل | ✅ في `voucher_redemptions` | ✅ في `voucher_redemptions` |

---

## 🔍 أوامر مهمة بالتفصيل

### `/addbot` - إضافة بوت

**الكود**:
```php
// control_bot.php:147
case '/addbot': {
    [$label, $token] = $args;
    $channel = $args[2] ?? null;
    $max = isset($args[3]) ? (int)$args[3] : 20;
    
    // إدراج في sub_bots
    $stmt = $db->prepare("INSERT INTO sub_bots(...) VALUES(?,?,?,?,?,0)");
    $stmt->execute([$label, $token, $channel, $max, $daily]);
    
    // انتظار رسالة الترحيب
    $db->prepare("INSERT INTO control_sessions(...) VALUES(?, 'await_welcome', ?)")
       ->execute([$from_id, $token]);
    
    // إرسال رابط Webhook
    $webhookUrl = $DOMAIN . "/sub_bot.php?bot=" . urlencode($token);
    tg_send($CONTROL_TOKEN, $chat_id, "✅ تم إضافة البوت...");
}
```

---

### `/broadcast` - بث في بوت التحكم

**الكود**:
```php
// control_bot.php:690
case '/broadcast': {
    $label = array_shift($args);
    $payload = trim(substr($text, strlen('/broadcast ' . $label)));
    
    // جلب البوت
    $stmt = $db->prepare("SELECT bot_token FROM sub_bots WHERE label=?");
    $stmt->execute([$label]);
    $bot = $stmt->fetch();
    $tok = $bot['bot_token'];
    
    // جلب المستخدمين
    $stmt = $db->prepare("SELECT user_id FROM allowed_users WHERE bot_token=? AND banned=0");
    $stmt->execute([$tok]);
    $users = $stmt->fetchAll();
    
    // الحلقة
    $sent=0; $fail=0;
    foreach ($users as $u) {
        $r = tg_call($tok, 'sendMessage', [...]);
        if (!empty($r['ok'])) $sent++; else $fail++;
        usleep(200000); // 0.2s
    }
    
    tg_send($CONTROL_TOKEN, $chat_id, "📢 تم الإرسال: ✅ {$sent} | ❌ {$fail}");
}
```

---

### `/broadcast` - بث في البوتات الفرعية

**الكود**:
```php
// sub_bot.php:385
case '/broadcast': {
    if (!has_permission($user_id, 1, $token)) {
        tg_send($token, $chat_id, "⛔️ ليس لديك صلاحية البث");
        exit;
    }
    
    // جلب المستخدمين (DISTINCT)
    $users = $db->prepare("SELECT DISTINCT user_id FROM allowed_users WHERE bot_token=? AND banned=0");
    $users->execute([$token]);
    $list = $users->fetchAll(PDO::FETCH_COLUMN);
    
    // الحلقة
    $success = 0; $failed = 0;
    foreach ($list as $uid) {
        $result = tg_send($token, $uid, $arg);
        if ($result) $success++; else $failed++;
        usleep(50000); // 50ms
    }
    
    // تسجيل
    $db->prepare("INSERT INTO broadcast_log(...) VALUES(?,?,?,?)")
        ->execute([$token, $user_id, substr($arg, 0, 500), $success]);
    
    tg_send($token, $chat_id, "✅ اكتمل البث\n\n✅ نجح: {$success}\n❌ فشل: {$failed}");
}
```

**الاختلاف الرئيسي**: 
- بوت التحكم: `SELECT user_id FROM allowed_users...` (قد يكرر)
- البوتات الفرعية: `SELECT DISTINCT user_id FROM allowed_users...` (لا تكرار)

---

## 🎯 الخلاصة

النظام يحتوي على **مجموعة شاملة من الأوامر** مقسمة بشكل واضح:
- ✅ بوت التحكم: إدارة كاملة للمالك
- ✅ البوتات الفرعية: صلاحيات محددة للمدراء
- ✅ نظام صلاحيات مرن (1-6)
- ⚠️ بعض الأوامر تحتاج لتحسين (Pagination)
