# 🏗️ بنية المشروع (Project Structure)

## البنية الكاملة للمشروع بعد التحديثات

---

## 📁 الهيكل العام

```
ARCHIVE_DOCS/
│
├── 📄 الملفات الرئيسية (Core Files)
│   ├── control_bot.php ✨ محدّث
│   ├── sub_bot.php ✨ محدّث
│   ├── .env.php
│   └── cron_limits_maintenance.php
│
├── 📚 مكتبات (Libraries)
│   ├── lib/
│   │   ├── telegram.php ✨ محدّث (دوال تقسيم جديدة)
│   │   ├── limits_core.php
│   │   ├── limits.php
│   │   ├── steam.php
│   │   └── help_content.php
│
├── 🗄️ قاعدة البيانات (Database)
│   ├── main.sql.sql (الأصلي)
│   ├── supehgku_botsteampro (1).sql (الأصلي)
│   └── sql_updates/ 🆕
│       ├── 01_vouchers_groups_support.sql
│       ├── 02_user_limits.sql
│       └── 03_update_help_system.sql
│
├── 📖 التوثيق (Documentation)
│   ├── للمالك_اقرأني_أولاً.txt 🆕 [ابدأ هنا!]
│   ├── INDEX.md 🆕 [الفهرس الشامل]
│   ├── QUICK_START_GUIDE.md 🆕
│   ├── README_UPDATED.md 🆕
│   ├── COMMANDS_REFERENCE.md 🆕
│   ├── FINAL_REPORT.md 🆕
│   ├── IMPLEMENTATION_SUMMARY.md 🆕
│   ├── CHANGES_APPLIED.md 🆕
│   ├── INSTALLATION_CHECKLIST.md 🆕
│   └── PROJECT_STRUCTURE.md 🆕 [هذا الملف]
│
└── 📊 تقارير التحليل (Analysis Reports)
    └── analysis_report/
        ├── README.md
        ├── architecture_overview.md
        ├── database_schema.md
        ├── commands_overview.md
        ├── broadcast_system.md
        ├── vouchers_system.md
        ├── groups_system.md
        ├── limits_system.md
        ├── known_issues.md
        └── recommendations.md
```

---

## 📊 الملفات حسب الأولوية

### 🔴 أولوية قصوى (للبدء)

| الملف | الوصف | الوقت |
|------|-------|------|
| `للمالك_اقرأني_أولاً.txt` | ملخص تنفيذي سريع | 2 دقيقة |
| `QUICK_START_GUIDE.md` | دليل البدء | 5 دقائق |
| `sql_updates/*.sql` | ملفات SQL للتنفيذ | 3 دقائق |

### 🟡 أولوية متوسطة (للاستخدام)

| الملف | الوصف | الوقت |
|------|-------|------|
| `COMMANDS_REFERENCE.md` | مرجع الأوامر | 15 دقيقة |
| `README_UPDATED.md` | الدليل الشامل | 30 دقيقة |
| `INDEX.md` | الفهرس | 10 دقائق |

### 🟢 أولوية منخفضة (للتعمق)

| الملف | الوصف | الوقت |
|------|-------|------|
| `FINAL_REPORT.md` | التقرير النهائي | 20 دقيقة |
| `IMPLEMENTATION_SUMMARY.md` | تفاصيل التنفيذ | 20 دقيقة |
| `CHANGES_APPLIED.md` | سجل التعديلات | 10 دقائق |
| `INSTALLATION_CHECKLIST.md` | قائمة التحقق | حسب الحاجة |
| `PROJECT_STRUCTURE.md` | بنية المشروع | 10 دقائق |
| `analysis_report/` | تقارير التحليل | 2 ساعة |

---

## 🔧 الملفات المُعدّلة

### control_bot.php ✨

**التعديلات الرئيسية**:
- ✅ إصلاح `/list` - تقسيم تلقائي
- ✅ إصلاح `/allusers` - تقسيم ذكي  
- ✅ إضافة `/users_count`
- ✅ تحسين `/generate_voucher` - دعم المجموعات
- ✅ تحسين `/redeem` - التحقق من المجموعات
- ✅ تحسين `/groups_list` - عرض البوتات
- ✅ إضافة `/group_bind_multi` و `/group_unbind_multi`
- ✅ إضافة 3 أوامر حدود المستخدمين
- ✅ إضافة 5 أوامر Webhook
- ✅ إضافة 6 أوامر إحصاءات
- ✅ إضافة 5 أوامر الردود
- ✅ إضافة `/show_welcome_messages`

**عدد الأسطر المُضافة**: ~500 سطر

### sub_bot.php ✨

**التعديلات الرئيسية**:
- ✅ إصلاح `/broadcast` - منع التكرار اللانهائي
- ✅ استبعاد المدير من قائمة البث
- ✅ إصلاح فحص نجاح الإرسال

**عدد الأسطر المُعدّلة**: ~20 سطر

### lib/telegram.php ✨

**التعديلات الرئيسية**:
- ✅ إضافة `tg_send_long()` - تقسيم الرسائل الطويلة
- ✅ إضافة `split_long_message()` - دالة مساعدة
- ✅ دعم ترقيم الصفحات تلقائياً
- ✅ تأخير 300ms بين الرسائل

**عدد الأسطر المُضافة**: ~90 سطر

---

## 🗄️ قاعدة البيانات

### الجداول الموجودة (34 جدول)

#### الجداول الأساسية
- `sub_bots` - البوتات الفرعية
- `allowed_users` - المستخدمون المسموح لهم
- `steam_accounts` - حسابات Steam
- `steam_requests` - سجل الطلبات

#### المجموعات
- `account_groups` - المجموعات
- `bot_groups` - ربط البوتات بالمجموعات
- `group_accounts` - ربط الحسابات بالمجموعات

#### الحدود
- `limits_global` - الحدود العامة
- `limits_bot` - حدود البوتات
- `limits_override` - حدود الحسابات
- `limits_user` 🆕 - حدود المستخدمين
- `limit_bans` - قائمة الحظر
- `limit_counters` - عدادات الاستخدام

#### القسائم
- `vouchers` ✨ - القسائم (تم تعديلها)
  - إضافة `target_group_id` 🆕
- `voucher_redemptions` - سجل التفعيل

#### البث
- `broadcast_log` - سجل البث

#### الإدارة
- `bot_managers` - المديرون الفرعيون
- `control_sessions` - جلسات بوت التحكم
- `message_templates` - قوالب الرسائل
- `system_logs` - سجل النظام

### التعديلات على قاعدة البيانات

#### 1. vouchers (تعديل)
```sql
ALTER TABLE vouchers 
ADD COLUMN target_group_id INT(11) DEFAULT NULL;
```
**الغرض**: دعم القسائم المرتبطة بمجموعات

#### 2. limits_user (جدول جديد)
```sql
CREATE TABLE limits_user (
  id BIGINT(20) PRIMARY KEY AUTO_INCREMENT,
  user_id BIGINT(20) NOT NULL,
  bot_label VARCHAR(64) DEFAULT NULL,
  mode ENUM('daily','weekly','monthly'),
  per_day INT(11),
  weekly_cap INT(11),
  monthly_cap INT(11),
  ban_days INT(11),
  ...
);
```
**الغرض**: حدود مخصصة لكل مستخدم

#### 3. message_templates (تحديثات)
- تحديث جميع قوالب `/help`
- إضافة قسمين جديدين: `help_stats` و `help_responses`

---

## 🎯 الميزات حسب الملف

### control_bot.php

#### إدارة البوتات
```php
/addbot, /list ✨, /pause, /resume, /deletebot, /refreshbot
/setmax, /setchannel, /setwelcome
/show_welcome_messages 🆕
```

#### Webhook 🆕
```php
/webhook_create, /webhook_enable, /webhook_reset
/webhook_delete, /webhook_info
```

#### المستخدمون
```php
/users, /allusers ✨, /users_count 🆕
/checkuser, /ban, /unban, /adduser, /kickuser
```

#### المجموعات
```php
/group_add, /groups_list ✨, /group_info, /group_toggle
/group_bind, /group_unbind
/group_bind_multi 🆕, /group_unbind_multi 🆕
/group_account_add, /group_account_remove
```

#### القسائم
```php
/generate_voucher ✨, /redeem ✨
/vouchers, /voucher_search
```

#### الحدود
```php
/set_daily_all, /limit_mode
/override_account, /override_clear
/set_user_limit 🆕, /clear_user_limit 🆕, /show_user_limit 🆕
/show_limit
```

#### البث
```php
/broadcast, /broadcast_all, /broadcast_log
```

#### الإحصاءات 🆕
```php
/stats_bots, /stats_users, /stats_groups
/stats_vouchers, /stats_broadcast, /stats_all
```

#### الردود 🆕
```php
/response_add, /response_edit, /response_delete
/response_list, /response_view
```

### sub_bot.php

#### أوامر المستخدمين
```php
/start - الترحيب
[account_name] - طلب كود
```

#### أوامر المديرين الفرعيين
```php
/admin, /users, /search, /ban, /unban
/top_users, /broadcast ✨, /broadcast_log
/redeem, /vouchers_log, /mystats, /userstats
/codes_today, /quota
```

### lib/telegram.php

#### دوال Telegram API
```php
tg_call() - استدعاء API
tg_send() - إرسال رسالة عادية
tg_send_long() 🆕 - إرسال رسالة طويلة (تقسيم تلقائي)
```

#### دوال المساعدة
```php
split_long_message() 🆕 - تقسيم النص
template_get() - جلب قالب
template_set() - حفظ قالب
interpolate() - استبدال المتغيرات
```

---

## 📈 الإحصاءات

### الكود

| المقياس | القيمة |
|---------|--------|
| ملفات PHP معدّلة | 3 |
| أسطر مُضافة | ~600 سطر |
| دوال جديدة | 2 (tg_send_long, split_long_message) |
| أوامر جديدة | 27 أمر |
| أوامر محسّنة | 6 أوامر |

### قاعدة البيانات

| المقياس | القيمة |
|---------|--------|
| جداول جديدة | 1 (limits_user) |
| جداول معدّلة | 1 (vouchers) |
| حقول مُضافة | 1 (target_group_id) |
| قوالب محدّثة | 9 قوالب |
| قوالب جديدة | 2 قوالب |

### التوثيق

| المقياس | القيمة |
|---------|--------|
| ملفات توثيق جديدة | 10 ملفات |
| ملفات SQL جديدة | 3 ملفات |
| أمثلة عملية | 20+ مثال |
| صفحات توثيق | 100+ صفحة |

---

## 🔄 تدفق المعلومات

### طلب كود Steam Guard

```
المستخدم → sub_bot.php
             ↓
      البحث عن الحساب (مع التحقق من المجموعة)
             ↓
      check_and_consume_limit() في limits_core.php
             ↓
      get_effective_limits() في limits.php
             ↓
      الأولويات: override → user 🆕 → bot → global
             ↓
      steam_guard_code() في steam.php
             ↓
      tg_send() في telegram.php
             ↓
      رد للمستخدم
```

### قسيمة لمجموعة 🆕

```
المالك → /generate_voucher users 100 group:36k
          ↓
    control_bot.php
          ↓
    التحقق من وجود المجموعة
          ↓
    إنشاء القسيمة مع target_group_id
          ↓
    المستخدم → /redeem VXXXX bot1
          ↓
    التحقق من ربط bot1 بالمجموعة
          ↓
    إذا مرتبط: تفعيل ✅
    إذا غير مرتبط: رفض ❌
```

---

## 🎨 الأنماط البرمجية المُتبعة

### PSR-12 Standards
- ✅ 4 مسافات للإزاحة
- ✅ أقواس معتلة على سطر جديد
- ✅ تسميات camelCase للدوال

### أمان
- ✅ Prepared Statements
- ✅ htmlspecialchars للنصوص
- ✅ Type Casting
- ✅ Try-Catch للأخطاء

### التوافق
- ✅ الأسلوب متسق مع الكود الموجود
- ✅ لم يتم حذف أي وظيفة قديمة
- ✅ التعليقات بالعربية

---

## 📦 الحزم والمكتبات

### المطلوبة
- PHP 8.3+
- PDO extension
- cURL extension
- MariaDB 11.4+

### المستخدمة
- لا توجد حزم خارجية (Composer)
- جميع الدوال مكتوبة يدوياً

---

## 🔐 الأمان والأداء

### الأمان
- ✅ جميع استعلامات SQL تستخدم Prepared Statements
- ✅ التحقق من الصلاحيات في كل أمر
- ✅ تنظيف جميع المدخلات
- ✅ معالجة الأخطاء بشكل آمن

### الأداء
- ✅ استعلامات محسّنة
- ✅ Indexes على الحقول المهمة
- ✅ LIMIT في الاستعلامات الكبيرة
- ✅ تأخير مناسب في البث (50ms)

---

## 📚 المصادر

### للمطورين
- `analysis_report/` - تحليل معماري شامل
- `IMPLEMENTATION_SUMMARY.md` - تفاصيل التنفيذ
- `CHANGES_APPLIED.md` - سجل التعديلات

### للمستخدمين
- `QUICK_START_GUIDE.md` - البدء السريع
- `COMMANDS_REFERENCE.md` - مرجع الأوامر
- `README_UPDATED.md` - الدليل الشامل

---

## ✅ الخلاصة

البنية الحالية:
- ✅ منظمة ومرتبة
- ✅ موثقة بالكامل
- ✅ قابلة للتوسع
- ✅ سهلة الصيانة

---

**آخر تحديث**: نوفمبر 2024  
**الإصدار**: 2.0  
**الحالة**: مستقر ✅
