# ✅ قائمة التحقق من التثبيت (Installation Checklist)

## استخدم هذه القائمة للتأكد من إكمال كل شيء بنجاح

---

## 📋 المرحلة 1: ما قبل التثبيت

### التحضيرات
- [ ] قرأت ملف `للمالك_اقرأني_أولاً.txt`
- [ ] أنشأت نسخة احتياطية من قاعدة البيانات
- [ ] أنشأت نسخة احتياطية من الملفات (`control_bot.php`, `sub_bot.php`, `lib/telegram.php`)
- [ ] تأكدت من صلاحيات الوصول لقاعدة البيانات

### المتطلبات
- [ ] PHP 8.3+ متوفر
- [ ] MariaDB 11.4+ متوفر
- [ ] الوصول لـ phpMyAdmin أو MySQL CLI

---

## 📋 المرحلة 2: تنفيذ SQL

### الملف الأول: دعم المجموعات في القسائم
```bash
sql_updates/01_vouchers_groups_support.sql
```
- [ ] فتحت الملف
- [ ] نسخت المحتوى
- [ ] نفّذته في قاعدة البيانات
- [ ] ظهرت رسالة "تم التنفيذ بنجاح"
- [ ] تحققت من وجود حقل `target_group_id` في جدول `vouchers`

**التحقق**:
```sql
DESC vouchers;
-- يجب أن ترى: target_group_id
```

### الملف الثاني: نظام حدود المستخدمين
```bash
sql_updates/02_user_limits.sql
```
- [ ] فتحت الملف
- [ ] نسخت المحتوى
- [ ] نفّذته في قاعدة البيانات
- [ ] ظهرت رسالة "تم التنفيذ بنجاح"
- [ ] تحققت من إنشاء جدول `limits_user`

**التحقق**:
```sql
SHOW TABLES LIKE 'limits_user';
-- يجب أن ترى: limits_user
```

### الملف الثالث: تحديث نظام المساعدة
```bash
sql_updates/03_update_help_system.sql
```
- [ ] فتحت الملف
- [ ] نسخت المحتوى
- [ ] نفّذته في قاعدة البيانات
- [ ] ظهرت رسالة "تم التنفيذ بنجاح"
- [ ] تحققت من تحديث قوالب المساعدة

**التحقق**:
```sql
SELECT COUNT(*) FROM message_templates WHERE `key` LIKE 'help_%';
-- يجب أن يكون العدد 9 أو أكثر
```

---

## 📋 المرحلة 3: اختبار الأوامر الأساسية

### الأوامر العامة
- [ ] `/users_count` - يعمل ويعرض العدد
- [ ] `/list` - يعرض البوتات (مع تقسيم إذا كانت كثيرة)
- [ ] `/groups_list` - يعرض المجموعات مع البوتات

### الإحصاءات
- [ ] `/stats_all` - يعرض الملخص الشامل
- [ ] `/stats_bots` - يعرض إحصاءات البوتات
- [ ] `/stats_users` - يعرض أكثر 5 مستخدمين نشاطاً

### Webhook
- [ ] `/webhook_info bot_label` - يعرض معلومات Webhook
  (استبدل `bot_label` بأحد بوتاتك)

### المجموعات (إذا كانت موجودة)
- [ ] `/groups_list` - يعرض البوتات المرتبطة بكل مجموعة
- [ ] يعرض البوتات المرتبطة بأكثر من مجموعة (إن وُجدت)

---

## 📋 المرحلة 4: اختبار الميزات الجديدة

### قسائم المجموعات
- [ ] أنشأت قسيمة لمجموعة: `/generate_voucher users 10 group:test_group`
- [ ] حاولت تفعيلها في بوت غير مرتبط (يجب أن تُرفض)
- [ ] فعّلتها في بوت مرتبط (يجب أن تنجح)

### ربط متعدد
- [ ] جربت `/group_bind_multi group_name bot1 bot2`
- [ ] تحققت من `/group_info group_name` - يظهر البوتات
- [ ] جربت `/group_unbind_multi group_name bot1 bot2`

### حدود المستخدمين
- [ ] جربت `/set_user_limit user_id daily 20`
- [ ] تحققت `/show_user_limit user_id` - يظهر الحدود
- [ ] جربت `/clear_user_limit user_id`

### الردود
- [ ] جربت `/response_add test_key test text`
- [ ] تحققت `/response_view test_key`
- [ ] جربت `/response_list` - يظهر `test_key`
- [ ] جربت `/response_delete test_key`

---

## 📋 المرحلة 5: اختبار الإصلاحات

### تقسيم الرسائل الطويلة
- [ ] إذا كان لديك 50+ بوت، `/list` يُقسّم تلقائياً
- [ ] إذا كان لديك 500+ مستخدم، `/allusers` يُقسّم تلقائياً
- [ ] الرسائل تحتوي على "📄 صفحة X من Y"

### البث في البوتات الفرعية
- [ ] في بوت فرعي، جربت `/broadcast test message`
- [ ] الرسالة لم تصل إليك (المدير) ✅
- [ ] الرسالة أُرسلت مرة واحدة فقط لكل مستخدم ✅
- [ ] لا حلقة لانهائية ✅

### القسائم المحسّنة
- [ ] قسيمة المجموعة تُرفض في بوت غير مرتبط ✅
- [ ] رسالة الخطأ واضحة ومفيدة ✅

---

## 📋 المرحلة 6: التوثيق

### قرأت الملفات المهمة
- [ ] `QUICK_START_GUIDE.md` - دليل البدء السريع
- [ ] `COMMANDS_REFERENCE.md` - جميع الأوامر
- [ ] `للمالك_اقرأني_أولاً.txt` - الملخص التنفيذي
- [ ] `INDEX.md` - الفهرس الشامل

### مرجعية للمستقبل
- [ ] حفظت موقع `COMMANDS_REFERENCE.md` للرجوع السريع
- [ ] وضعت إشارة مرجعية لـ `INDEX.md`
- [ ] احتفظت بنسخة من ملفات SQL

---

## 📋 المرحلة 7: التخصيص (اختياري)

### إعداد الردود المخصصة
- [ ] أضفت ردود مخصصة حسب احتياجك
- [ ] حدّثت رسائل الترحيب للبوتات

### إعداد المجموعات والقسائم
- [ ] أنشأت المجموعات المطلوبة
- [ ] ربطت البوتات بالمجموعات
- [ ] أنشأت قسائم خاصة بالمجموعات

### تكوين الحدود
- [ ] راجعت الحدود العامة
- [ ] عيّنت حدود خاصة للبوتات (إن لزم)
- [ ] عيّنت حدود خاصة لمستخدمين VIP (إن لزم)

---

## 📋 المرحلة 8: المراقبة اليومية

### إعداد روتين يومي
- [ ] أضفت `/stats_all` للمراجعة اليومية
- [ ] حددت وقت لمراجعة `/stats_users`
- [ ] جدولت فحص `/groups_list` أسبوعياً

---

## ✅ النتيجة النهائية

### إذا أكملت كل ما سبق:
```
✅ التثبيت كامل
✅ جميع الميزات تعمل
✅ الإصلاحات فعّالة
✅ التوثيق مقروء
✅ النظام جاهز للإنتاج
```

---

## 🎉 تهانينا!

إذا وصلت هنا، فأنت الآن:
- ✅ أكملت التثبيت بنجاح
- ✅ اختبرت جميع الميزات الجديدة
- ✅ تحققت من الإصلاحات
- ✅ جاهز للاستخدام اليومي

---

## 📞 إذا واجهت مشكلة

### المشكلة: ملف SQL لا ينفذ
**الحل**: تحقق من:
- صلاحيات قاعدة البيانات
- نسخة MariaDB/MySQL
- راجع `QUICK_START_GUIDE.md` - قسم استكشاف الأخطاء

### المشكلة: أمر لا يعمل
**الحل**:
1. تأكد من تنفيذ جميع ملفات SQL
2. تحقق من تحديث `control_bot.php`
3. راجع `FINAL_REPORT.md`

### المشكلة: Webhook لا يستجيب
**الحل**:
```
/webhook_info bot_label
/webhook_reset bot_label
```

---

## 📊 إحصاءات التقدم

احسب نسبة إنجازك:

**المرحلة 1**: ____ / 5 مهام
**المرحلة 2**: ____ / 15 مهام
**المرحلة 3**: ____ / 9 مهام
**المرحلة 4**: ____ / 12 مهام
**المرحلة 5**: ____ / 9 مهام
**المرحلة 6**: ____ / 7 مهام
**المرحلة 7**: ____ / 9 مهام
**المرحلة 8**: ____ / 3 مهام

**الإجمالي**: ____ / 69 مهمة

**النسبة المئوية**: ____ %

---

## 🎯 الهدف: 100%

أكمل جميع المهام للوصول إلى تثبيت كامل ومثالي!

---

**تاريخ البدء**: _______________
**تاريخ الإنجاز**: _______________
**المدة الإجمالية**: _______________

---

💡 **نصيحة**: احتفظ بهذا الملف مرجعاً لك، وضع علامة ✅ على كل مهمة تنجزها!
