-- ================================================================
-- تحديث نصوص المساعدة الأصلية - الأوامر الجديدة
-- ================================================================
-- التاريخ: 2025-10-25
-- الهدف: تحديث help_part1, help_part3, help_part4 لإضافة الأوامر الجديدة
-- ================================================================

-- ═══════════════════════════════════════════════════════════════
-- 1. تحديث help_part1 (قسم البوتات) - إضافة /bot_rename + /bot_details
-- ═══════════════════════════════════════════════════════════════

UPDATE `message_templates` SET `text` = 
'🧠 <b>لوحة أوامر الإدارة الشاملة</b>

جميع الأوامر للمالك فقط.

🛠 <b>قسم إدارة البوتات</b>

<b>/addbot</b> <code>label token [channel] [max]</code>
➡️ إضافة بوت جديد للنظام
💡 <code>/addbot mybot 7123456:ABC @channel 100</code>
📝 <i>label: اسم البوت، token: توكن من BotFather، channel: قناة اشتراك إلزامي، max: أقصى عدد مستخدمين</i>
⚠️ <i>لتحديد عدد الطلبات: استخدم نظام الحدود الذكي (/help limits)</i>

<b>/list</b>
➡️ عرض جميع البوتات المسجلة مع تفاصيلها
📊 يعرض: الاسم، عدد المستخدمين، الحالة، القناة

<b>/bot_rename</b> <code>old_label new_label</code> 🆕
➡️ تعديل اسم بوت (مع تحديث تلقائي للحدود والعدادات)
💡 <code>/bot_rename test1 test_new</code>

<b>/bot_details</b> <code>label</code> 🆕
➡️ معلومات تفصيلية: المجموعات + الحسابات + الحدود
💡 <code>/bot_details test1</code>

<b>/pause</b> <code>label</code>
➡️ إيقاف بوت مؤقتاً (لا يستجيب للمستخدمين)
💡 <code>/pause mybot</code>

<b>/resume</b> <code>label</code>
➡️ تشغيل بوت متوقف
💡 <code>/resume mybot</code>

<b>/setmax</b> <code>label n</code>
➡️ تحديد الحد الأقصى لعدد المستخدمين
💡 <code>/setmax mybot 500</code>

<b>/incmax</b> <code>label delta</code>
➡️ زيادة الحد الأقصى بمقدار معين
💡 <code>/incmax mybot 100</code> = زيادة 100 مستخدم

<b>/setchannel</b> <code>label channel_id</code>
➡️ تعديل قناة الاشتراك الإلزامية
💡 <code>/setchannel mybot @mychannel</code>
💡 <code>/setchannel mybot -1001234567890</code>

<b>/settoken</b> <code>label new_token</code>
➡️ تحديث توكن البوت
💡 <code>/settoken mybot 7123456:NEW_TOKEN</code>

<b>/setwelcome</b> <code>label text</code>
➡️ تعديل رسالة الترحيب
💡 <code>/setwelcome mybot مرحباً بك في البوت!</code>

<b>/refreshbot</b> <code>label</code>
➡️ إعادة تهيئة Webhook (مفيد بعد تغيير النطاق)
💡 <code>/refreshbot mybot</code>

<b>/deletebot</b> <code>label confirm</code>
➡️ حذف البوت نهائياً من النظام
⚠️ يتطلب كلمة confirm للتأكيد
💡 <code>/deletebot mybot confirm</code>'
WHERE `key` = 'help_part1';

-- ═══════════════════════════════════════════════════════════════
-- 2. تحديث help_part3 (قسم الحسابات) - إضافة /account_details
-- ═══════════════════════════════════════════════════════════════

UPDATE `message_templates` SET `text` = 
'🎮 <b>قسم الحسابات</b>

<b>/accounts</b>
➡️ عرض جميع حسابات Steam Guard
📊 يعرض: الاسم، الحالة، محاولات يومية مخصصة

<b>/addaccount</b> <code>name secret</code>
➡️ إضافة حساب Steam Guard جديد
💡 <code>/addaccount main_acc dG90YWxseV9yYW5kb20=</code>
📝 <i>secret يجب أن يكون base64</i>

<b>/addaccounts</b>
➡️ إضافة عدة حسابات دفعة واحدة
📝 أرسل الأمر، ثم أرسل في رسالة منفصلة:
<code>account1:secret1
account2:secret2
account3:secret3</code>
💡 مثال:
<code>main:ABC123==
vip:XYZ789==
backup:DEF456==</code>

<b>/editaccount</b> <code>name secret [active]</code>
➡️ تعديل بيانات حساب
💡 <code>/editaccount main NEW_SECRET 1</code>
💡 <code>/editaccount main same 0</code> = تعطيل بدون تغيير السر

<b>/disableaccount</b> <code>name</code>
➡️ تعطيل حساب (لن يُستخدم في توليد الأكواد)
💡 <code>/disableaccount backup</code>

<b>/enableaccount</b> <code>name</code>
➡️ تفعيل حساب معطل
💡 <code>/enableaccount backup</code>

<b>/account_details</b> <code>name_or_id</code> 🆕
➡️ معلومات شاملة: المجموعة + البوتات + الحدود الخاصة
💡 <code>/account_details steamuser1</code>
💡 <code>/account_details 42</code>

<b>/deleteaccount</b> <code>name</code>
➡️ حذف حساب نهائياً من النظام
⚠️ لا يمكن التراجع!
💡 <code>/deleteaccount old_account</code>

<b>/accountinfo</b> <code>name</code>
➡️ عرض معلومات تفصيلية عن حساب
💡 <code>/accountinfo main</code>
📊 يعرض: الحالة، إجمالي الطلبات، آخر استخدام'
WHERE `key` = 'help_part3';

-- ═══════════════════════════════════════════════════════════════
-- 3. تحديث help_part4 (قسم المجموعات) - إضافة /group_details
-- ═══════════════════════════════════════════════════════════════

UPDATE `message_templates` SET `text` = 
'📂 <b>قسم المجموعات</b> (النظام الجديد) ✨

💡 <i>نظام متطور لتجميع الحسابات وربطها بالبوتات</i>

<b>📋 إدارة المجموعات:</b>
<b>/group_add</b> <code>name</code> - إنشاء مجموعة جديدة
💡 <code>/group_add vip</code>

<b>/group_rename</b> <code>old new</code> - إعادة تسمية 🆕
💡 <code>/group_rename vip premium</code>

<b>/group_delete</b> <code>name confirm</code> - حذف نهائي 🆕
💡 <code>/group_delete old confirm</code>

<b>/group_lock</b> <code>name</code> - قفل (منع rename/delete) 🆕
<b>/group_unlock</b> <code>name</code> - فتح القفل 🆕

<b>/groups_list</b> - عرض جميع المجموعات
💡 يعرض المجموعات مع عداد البوتات والحسابات

<b>/group_details</b> <code>name</code> 🆕
➡️ معلومات تفصيلية: البوتات + الحسابات (بالأسماء والأرقام)
💡 <code>/group_details default</code>

<b>/group_info</b> <code>group</code> - تفاصيل مجموعة
💡 <code>/group_info default</code>

<b>/group_toggle</b> <code>group</code> - تفعيل/تعطيل
💡 <code>/group_toggle vip</code>

<b>/group_usage</b> <code>group</code> - إحصائيات الاستخدام 🆕
💡 <code>/group_usage vip</code>

<b>🤖 ربط البوتات:</b>
<b>/group_bind</b> <code>bot group</code> - ربط بوت بمجموعة
💡 <code>/group_bind mybot vip</code>

<b>/group_unbind</b> <code>bot group</code> - فك ربط بوت
💡 <code>/group_unbind mybot vip</code>

<b>/bot_groups</b> <code>bot</code> - عرض مجموعات وحسابات بوت 🆕
💡 <code>/bot_groups mybot</code>

<b>👤 إدارة الحسابات (دفعات):</b>
<b>/group_account_add</b> <code>group acc1 acc2 ...</code> 🆕
➡️ إضافة حسابات لمجموعة (دفعة واحدة)
💡 <code>/group_account_add vip acc1 acc2 acc3</code>

<b>/group_account_del</b> <code>group acc1 acc2 ...</code> 🆕
➡️ إزالة حسابات من مجموعة (دفعة واحدة)
💡 <code>/group_account_del vip acc1 acc2</code>

⚠️ <i>البوت يرى فقط الحسابات الموجودة في مجموعاته</i>'
WHERE `key` = 'help_part4';

-- ================================================================
-- ✅ تم تحديث نصوص المساعدة!
-- ================================================================

-- التحقق من النتائج
SELECT `key`, LEFT(`text`, 100) as preview
FROM message_templates
WHERE `key` IN ('help_part1', 'help_part3', 'help_part4')
ORDER BY `key`;
