<?php
/**
 * الأوامر الجديدة للبوت المركزي
 * 
 * الأوامر المضافة:
 * 1. /bot_rename - تعديل اسم بوت
 * 2. /group_details - استعلام عن مجموعة (البوتات والحسابات المرتبطة)
 * 3. /bot_details - استعلام عن بوت (المجموعات والحسابات المرتبطة)
 * 4. /account_details - استعلام عن حساب (البوت، المجموعة، الحدود)
 */

// ═══════════════════════════════════════════════════════════════
// 1. تعديل اسم بوت
// ═══════════════════════════════════════════════════════════════

case '/bot_rename': {
    if (count($args) < 2) {
        tg_send($CONTROL_TOKEN, $chat_id, 
            "❌ <b>الاستخدام:</b>\n" .
            "<code>/bot_rename &lt;label_قديم&gt; &lt;label_جديد&gt;</code>\n\n" .
            "💡 <i>مثال:</i> <code>/bot_rename test1 test_new</code>");
        break;
    }
    
    $old_label = $args[0];
    $new_label = $args[1];
    
    // التحقق من البوت القديم
    $stmt = $db->prepare("SELECT * FROM sub_bots WHERE label=?");
    $stmt->execute([$old_label]);
    $bot = $stmt->fetch();
    
    if (!$bot) {
        tg_send($CONTROL_TOKEN, $chat_id, "❌ البوت <b>{$old_label}</b> غير موجود");
        break;
    }
    
    // التحقق من عدم وجود الاسم الجديد
    $stmt = $db->prepare("SELECT * FROM sub_bots WHERE label=?");
    $stmt->execute([$new_label]);
    if ($stmt->fetch()) {
        tg_send($CONTROL_TOKEN, $chat_id, "❌ الاسم <b>{$new_label}</b> مستخدم بالفعل");
        break;
    }
    
    try {
        // تحديث اسم البوت
        $stmt = $db->prepare("UPDATE sub_bots SET label=? WHERE label=?");
        $stmt->execute([$new_label, $old_label]);
        
        tg_send($CONTROL_TOKEN, $chat_id, 
            "✅ <b>تم تعديل اسم البوت بنجاح!</b>\n\n" .
            "الاسم القديم: <code>{$old_label}</code>\n" .
            "الاسم الجديد: <code>{$new_label}</code>\n\n" .
            "⚠️ <b>ملاحظة:</b> سيتم تحديث:\n" .
            "• الحدود الخاصة بالبوت\n" .
            "• العدادات المرتبطة\n" .
            "• الحظر المرتبط\n" .
            "تلقائياً (Foreign Key Cascade)");
    } catch (Exception $e) {
        tg_send($CONTROL_TOKEN, $chat_id, "❌ خطأ: " . $e->getMessage());
    }
    
    break;
}

// ═══════════════════════════════════════════════════════════════
// 2. استعلام عن مجموعة
// ═══════════════════════════════════════════════════════════════

case '/group_details': {
    if (count($args) < 1) {
        tg_send($CONTROL_TOKEN, $chat_id, 
            "❌ <b>الاستخدام:</b>\n" .
            "<code>/group_details &lt;group_name&gt;</code>\n\n" .
            "💡 <i>مثال:</i> <code>/group_details default</code>");
        break;
    }
    
    $group_name = $args[0];
    
    // الحصول على المجموعة
    $stmt = $db->prepare("SELECT * FROM account_groups WHERE group_name=?");
    $stmt->execute([$group_name]);
    $group = $stmt->fetch();
    
    if (!$group) {
        tg_send($CONTROL_TOKEN, $chat_id, "❌ المجموعة <b>{$group_name}</b> غير موجودة");
        break;
    }
    
    // الحصول على البوتات المرتبطة
    $stmt = $db->prepare("
        SELECT sb.id, sb.label, sb.is_paused
        FROM bot_groups bg
        JOIN sub_bots sb ON sb.id = bg.bot_id
        WHERE bg.group_id = ?
        ORDER BY sb.label ASC
    ");
    $stmt->execute([$group['id']]);
    $bots = $stmt->fetchAll();
    
    // الحصول على الحسابات المرتبطة
    $stmt = $db->prepare("
        SELECT sa.id, sa.account_name, sa.is_active
        FROM group_accounts ga
        JOIN steam_accounts sa ON sa.id = ga.account_id
        WHERE ga.group_id = ?
        ORDER BY sa.account_name ASC
    ");
    $stmt->execute([$group['id']]);
    $accounts = $stmt->fetchAll();
    
    // بناء الرد
    $status = $group['active'] ? '✅ نشطة' : '⛔ معطلة';
    $default = $group['is_default'] ? ' ⭐ (افتراضية)' : '';
    
    $out = "📂 <b>معلومات المجموعة: {$group_name}</b>{$default}\n\n";
    $out .= "🔹 <b>الحالة:</b> {$status}\n";
    $out .= "🔹 <b>الوصف:</b> " . ($group['description'] ?: 'لا يوجد') . "\n\n";
    
    // البوتات
    $out .= "🤖 <b>البوتات المرتبطة:</b> (" . count($bots) . ")\n";
    if ($bots) {
        foreach ($bots as $i => $bot) {
            $num = $i + 1;
            $status_icon = $bot['is_paused'] ? '⏸️' : '▶️';
            $out .= "{$num}. {$status_icon} <code>{$bot['label']}</code> (ID: {$bot['id']})\n";
        }
    } else {
        $out .= "   <i>لا توجد بوتات مرتبطة</i>\n";
    }
    
    $out .= "\n👤 <b>الحسابات المرتبطة:</b> (" . count($accounts) . ")\n";
    if ($accounts) {
        foreach ($accounts as $i => $acc) {
            $num = $i + 1;
            $status_icon = $acc['is_active'] ? '✅' : '❌';
            $out .= "{$num}. {$status_icon} <code>{$acc['account_name']}</code> (ID: {$acc['id']})\n";
        }
    } else {
        $out .= "   <i>لا توجد حسابات مرتبطة</i>\n";
    }
    
    tg_send($CONTROL_TOKEN, $chat_id, $out);
    break;
}

// ═══════════════════════════════════════════════════════════════
// 3. استعلام عن بوت
// ═══════════════════════════════════════════════════════════════

case '/bot_details': {
    if (count($args) < 1) {
        tg_send($CONTROL_TOKEN, $chat_id, 
            "❌ <b>الاستخدام:</b>\n" .
            "<code>/bot_details &lt;bot_label&gt;</code>\n\n" .
            "💡 <i>مثال:</i> <code>/bot_details test1</code>");
        break;
    }
    
    $bot_label = $args[0];
    
    // الحصول على البوت
    $stmt = $db->prepare("SELECT * FROM sub_bots WHERE label=?");
    $stmt->execute([$bot_label]);
    $bot = $stmt->fetch();
    
    if (!$bot) {
        tg_send($CONTROL_TOKEN, $chat_id, "❌ البوت <b>{$bot_label}</b> غير موجود");
        break;
    }
    
    // الحصول على المجموعات المرتبطة
    $stmt = $db->prepare("
        SELECT ag.id, ag.group_name, ag.active
        FROM bot_groups bg
        JOIN account_groups ag ON ag.id = bg.group_id
        WHERE bg.bot_id = ?
        ORDER BY ag.group_name ASC
    ");
    $stmt->execute([$bot['id']]);
    $groups = $stmt->fetchAll();
    
    // الحصول على الحسابات المرتبطة (عبر المجموعات)
    $stmt = $db->prepare("
        SELECT DISTINCT sa.id, sa.account_name, sa.is_active, ag.group_name
        FROM bot_groups bg
        JOIN group_accounts ga ON ga.group_id = bg.group_id
        JOIN steam_accounts sa ON sa.id = ga.account_id
        JOIN account_groups ag ON ag.id = ga.group_id
        WHERE bg.bot_id = ?
        ORDER BY ag.group_name, sa.account_name ASC
    ");
    $stmt->execute([$bot['id']]);
    $accounts = $stmt->fetchAll();
    
    // الحصول على الحدود الخاصة بالبوت
    $stmt = $db->prepare("SELECT * FROM limits_bot WHERE bot_label=?");
    $stmt->execute([$bot_label]);
    $limits = $stmt->fetch();
    
    // بناء الرد
    $status = $bot['is_paused'] ? '⏸️ متوقف' : '▶️ نشط';
    
    $out = "🤖 <b>معلومات البوت: {$bot_label}</b>\n\n";
    $out .= "🔹 <b>ID:</b> {$bot['id']}\n";
    $out .= "🔹 <b>الحالة:</b> {$status}\n";
    $out .= "🔹 <b>الحد الأقصى للمستخدمين:</b> {$bot['max_users']}\n\n";
    
    // المجموعات
    $out .= "📂 <b>المجموعات المرتبطة:</b> (" . count($groups) . ")\n";
    if ($groups) {
        foreach ($groups as $i => $group) {
            $num = $i + 1;
            $status_icon = $group['active'] ? '✅' : '⛔';
            $out .= "{$num}. {$status_icon} <code>{$group['group_name']}</code> (ID: {$group['id']})\n";
        }
    } else {
        $out .= "   <i>لا توجد مجموعات مرتبطة</i>\n";
    }
    
    // الحسابات
    $out .= "\n👤 <b>الحسابات المرتبطة:</b> (" . count($accounts) . ")\n";
    if ($accounts) {
        $current_group = '';
        $num = 1;
        foreach ($accounts as $acc) {
            if ($current_group !== $acc['group_name']) {
                $current_group = $acc['group_name'];
                $out .= "\n   📁 <b>{$current_group}:</b>\n";
            }
            $status_icon = $acc['is_active'] ? '✅' : '❌';
            $out .= "   {$num}. {$status_icon} <code>{$acc['account_name']}</code> (ID: {$acc['id']})\n";
            $num++;
        }
    } else {
        $out .= "   <i>لا توجد حسابات مرتبطة</i>\n";
    }
    
    // الحدود
    $out .= "\n⚙️ <b>الحدود الخاصة بالبوت:</b>\n";
    if ($limits) {
        $mode_ar = [
            'daily' => 'يومي',
            'weekly' => 'أسبوعي',
            'monthly' => 'شهري'
        ];
        $out .= "   • الوضع: " . ($mode_ar[$limits['mode']] ?? $limits['mode']) . "\n";
        $out .= "   • الحد اليومي: {$limits['per_day']} كود\n";
        if ($limits['weekly_cap']) $out .= "   • الحد الأسبوعي: {$limits['weekly_cap']} كود\n";
        if ($limits['monthly_cap']) $out .= "   • الحد الشهري: {$limits['monthly_cap']} كود\n";
        if ($limits['ban_days']) $out .= "   • مدة الحظر: {$limits['ban_days']} يوم\n";
    } else {
        $out .= "   <i>يستخدم الحدود العامة</i>\n";
    }
    
    tg_send($CONTROL_TOKEN, $chat_id, $out);
    break;
}

// ═══════════════════════════════════════════════════════════════
// 4. استعلام عن حساب
// ═══════════════════════════════════════════════════════════════

case '/account_details': {
    if (count($args) < 1) {
        tg_send($CONTROL_TOKEN, $chat_id, 
            "❌ <b>الاستخدام:</b>\n" .
            "<code>/account_details &lt;account_name أو ID&gt;</code>\n\n" .
            "💡 <i>مثال:</i> <code>/account_details steamuser123</code>\n" .
            "أو: <code>/account_details 42</code>");
        break;
    }
    
    $search = $args[0];
    
    // البحث بالاسم أو ID
    if (is_numeric($search)) {
        $stmt = $db->prepare("SELECT * FROM steam_accounts WHERE id=?");
        $stmt->execute([(int)$search]);
    } else {
        $stmt = $db->prepare("SELECT * FROM steam_accounts WHERE account_name=?");
        $stmt->execute([$search]);
    }
    
    $account = $stmt->fetch();
    
    if (!$account) {
        tg_send($CONTROL_TOKEN, $chat_id, "❌ الحساب <b>{$search}</b> غير موجود");
        break;
    }
    
    // الحصول على المجموعة
    $stmt = $db->prepare("
        SELECT ag.*
        FROM group_accounts ga
        JOIN account_groups ag ON ag.id = ga.group_id
        WHERE ga.account_id = ?
        LIMIT 1
    ");
    $stmt->execute([$account['id']]);
    $group = $stmt->fetch();
    
    // الحصول على البوتات المرتبطة (عبر المجموعة)
    $bots = [];
    if ($group) {
        $stmt = $db->prepare("
            SELECT sb.id, sb.label, sb.is_paused
            FROM bot_groups bg
            JOIN sub_bots sb ON sb.id = bg.bot_id
            WHERE bg.group_id = ?
            ORDER BY sb.label ASC
        ");
        $stmt->execute([$group['id']]);
        $bots = $stmt->fetchAll();
    }
    
    // الحصول على الحدود الخاصة بالحساب
    $stmt = $db->prepare("SELECT * FROM limits_override WHERE account_id=?");
    $stmt->execute([$account['id']]);
    $override_limits = $stmt->fetch();
    
    // بناء الرد
    $status = $account['is_active'] ? '✅ نشط' : '❌ معطل';
    
    $out = "👤 <b>معلومات الحساب: {$account['account_name']}</b>\n\n";
    $out .= "🔹 <b>ID:</b> {$account['id']}\n";
    $out .= "🔹 <b>الحالة:</b> {$status}\n";
    $out .= "🔹 <b>كلمة المرور:</b> <code>{$account['password']}</code>\n";
    $out .= "🔹 <b>Steam Guard:</b> " . ($account['steam_guard'] ?: 'لا يوجد') . "\n\n";
    
    // المجموعة
    $out .= "📂 <b>المجموعة المرتبطة:</b>\n";
    if ($group) {
        $status_icon = $group['active'] ? '✅' : '⛔';
        $out .= "   {$status_icon} <code>{$group['group_name']}</code> (ID: {$group['id']})\n";
    } else {
        $out .= "   <i>لا توجد مجموعة مرتبطة</i>\n";
    }
    
    // البوتات
    $out .= "\n🤖 <b>البوتات المرتبطة:</b> (" . count($bots) . ")\n";
    if ($bots) {
        foreach ($bots as $i => $bot) {
            $num = $i + 1;
            $status_icon = $bot['is_paused'] ? '⏸️' : '▶️';
            $out .= "   {$num}. {$status_icon} <code>{$bot['label']}</code> (ID: {$bot['id']})\n";
        }
    } else {
        $out .= "   <i>لا توجد بوتات مرتبطة</i>\n";
    }
    
    // الحدود
    $out .= "\n⚙️ <b>الحدود الخاصة:</b>\n";
    if ($override_limits) {
        $mode_ar = [
            'daily' => 'يومي',
            'weekly' => 'أسبوعي',
            'monthly' => 'شهري'
        ];
        $out .= "   ✅ <b>حدود خاصة بالحساب:</b>\n";
        $out .= "   • الوضع: " . ($mode_ar[$override_limits['mode']] ?? $override_limits['mode']) . "\n";
        $out .= "   • الحد اليومي: {$override_limits['per_day']} كود\n";
        if ($override_limits['cap']) $out .= "   • السقف: {$override_limits['cap']} كود\n";
        if ($override_limits['ban_days']) $out .= "   • مدة الحظر: {$override_limits['ban_days']} يوم\n";
    } else {
        $out .= "   <i>يستخدم حدود البوت أو الحدود العامة</i>\n";
        $out .= "   <i>الأولوية: override → bot → global</i>\n";
    }
    
    tg_send($CONTROL_TOKEN, $chat_id, $out);
    break;
}

?>
