# 🗺️ خريطة العلاقات - Entity Relationship Diagram

**التاريخ:** 2025-10-25  
**النظام:** supehgku_test0 (الجديد)

---

## 📊 نظرة عامة على العلاقات

```
┌─────────────────────────────────────────────────────────────────┐
│                     النظام الجديد المتقدم                      │
│                                                                 │
│  • 20+ جدول                                                     │
│  • 15+ Foreign Key                                              │
│  • نظام مجموعات متطور                                          │
│  • نظام حدود ذكي (يومي/أسبوعي/شهري)                           │
│  • نظام قسائم وبث                                              │
└─────────────────────────────────────────────────────────────────┘
```

---

## 🎯 المحور الرئيسي: نظام المجموعات

```
                         ┌──────────────────┐
                         │ account_groups   │
                         │                  │
                         │  id (PK)         │
                         │  group_name      │
                         │  is_default      │
                         │  locked          │
                         └────────┬─────────┘
                                  │
                    ┌─────────────┴─────────────┐
                    │                           │
                    ▼                           ▼
         ┌──────────────────┐        ┌──────────────────┐
         │ group_accounts   │        │   bot_groups     │
         │                  │        │                  │
         │ group_id (FK)    │        │ bot_id (FK)      │
         │ account_id (FK)  │        │ group_id (FK)    │
         └────────┬─────────┘        └────────┬─────────┘
                  │                           │
                  ▼                           ▼
         ┌──────────────────┐        ┌──────────────────┐
         │ steam_accounts   │        │   sub_bots       │
         │                  │        │                  │
         │ id (PK)          │        │ id (PK)          │
         │ account_name     │        │ label            │
         │ shared_secret    │        │ bot_token        │
         └──────────────────┘        └──────────────────┘
```

### العلاقات:
- **account_groups** ↔ **group_accounts** ↔ **steam_accounts** (many-to-many)
- **account_groups** ↔ **bot_groups** ↔ **sub_bots** (many-to-many)

---

## 👥 نظام المستخدمين والحدود

```
         ┌──────────────────┐
         │  allowed_users   │
         │                  │
         │  id (PK)         │
         │  bot_token       │◄────┐
         │  user_id         │     │
         │  banned          │     │
         └────────┬─────────┘     │
                  │               │
                  │               │ مرتبط بـ bot_token
                  │               │
         ┌────────▼─────────┐     │
         │ limit_counters   │     │
         │                  │     │
         │ id (PK)          │     │
         │ user_id          │     │
         │ account_id (FK)  │◄────┼─────────────┐
         │ day_used         │     │             │
         │ week_used        │     │             │
         │ month_used       │     │             │
         └────────┬─────────┘     │             │
                  │               │             │
         ┌────────▼─────────┐     │             │
         │  limit_bans      │     │             │
         │                  │     │             │
         │ id (PK)          │     │             │
         │ user_id          │     │             │
         │ account_id (FK)  │─────┘             │
         │ banned_until     │                   │
         └──────────────────┘                   │
                                                │
         ┌──────────────────────────────────────┘
         │
         ▼
    ┌──────────────────┐
    │ steam_accounts   │
    └──────────────────┘
```

### العلاقات:
- **allowed_users.bot_token** مرتبط بـ **sub_bots.bot_token** (غير رسمي)
- **limit_counters.account_id** → **steam_accounts.id** (FK)
- **limit_bans.account_id** → **steam_accounts.id** (FK)

---

## 📝 نظام القوالب والرسائل

```
    ┌──────────────────────┐
    │ message_templates    │◄──────┐
    │                      │       │
    │ key (PK)             │       │ القوالب العامة
    │ text                 │       │
    └──────────────────────┘       │
                                   │
    ┌──────────────────────┐       │
    │ bot_message_templates│───────┘
    │                      │
    │ id (PK)              │   ردود مخصصة لبوت معين
    │ bot_id (FK)          │◄──────────────────────┐
    │ template_key         │                       │
    │ template_text        │                       │
    └──────────────────────┘                       │
                                                   │
    ┌──────────────────────┐                       │
    │ limit_messages       │                       │
    │                      │                       │
    │ event (PK)           │   رسائل الأحداث       │
    │ text                 │                       │
    └──────────────────────┘                       │
                                                   │
                      ┌────────────────────────────┘
                      │
                      ▼
            ┌──────────────────┐
            │   sub_bots       │
            └──────────────────┘
```

### أولوية الردود:
1. **bot_message_templates** (خاص بالبوت)
2. **message_templates** (عام)
3. **limit_messages** (أحداث)

---

## 🎫 نظام القسائم (Vouchers)

```
    ┌──────────────────────┐
    │     vouchers         │
    │                      │
    │ id (PK)              │
    │ code (UNIQUE)        │
    │ voucher_type         │
    │ value                │
    │ max_uses             │
    │ used_count           │
    │ expires_at           │
    └─────────┬────────────┘
              │
              ├──────────────────────────────┐
              │                              │
              ▼                              ▼
    ┌──────────────────────┐      ┌──────────────────────┐
    │ voucher_redemptions  │      │   voucher_usage      │
    │                      │      │                      │
    │ id (PK)              │      │ id (PK)              │
    │ voucher_code (FK)    │      │ voucher_code         │
    │ bot_token            │      │ bot_id (FK)          │
    │ user_id              │      │ user_id              │
    │ redeemed_at          │      │ used_at              │
    └──────────────────────┘      └────────┬─────────────┘
                                           │
                                           ▼
                                  ┌──────────────────┐
                                  │   sub_bots       │
                                  └──────────────────┘
```

### العلاقات:
- **voucher_redemptions.voucher_code** → **vouchers.code**
- **voucher_usage.bot_id** → **sub_bots.id** (FK)

---

## 📢 نظام البث (Broadcast)

```
    ┌──────────────────────┐
    │  broadcast_jobs      │
    │                      │
    │ id (PK)              │
    │ job_key (UNIQUE)     │
    │ initiator_user_id    │
    │ bot_label            │
    │ message              │
    │ status               │
    │ total_users          │
    │ sent_count           │
    └──────────────────────┘

    ┌──────────────────────┐
    │  broadcast_log       │
    │                      │
    │ id (PK)              │
    │ bot_token            │
    │ manager_id           │
    │ message              │
    │ target_count         │
    │ sent_count           │
    │ created_at           │
    └──────────────────────┘
```

---

## 📊 نظام الحدود (Limits)

```
    ┌──────────────────────┐
    │  limits_global       │  الحدود العامة (افتراضية)
    │                      │
    │ id (PK)              │
    │ mode                 │  daily/weekly/monthly
    │ per_day              │
    │ per_week             │
    │ per_month            │
    └──────────────────────┘

    ┌──────────────────────┐
    │   limits_bot         │  حدود مخصصة لبوت
    │                      │
    │ bot_label (PK)       │
    │ mode                 │
    │ per_day/week/month   │
    └──────────────────────┘

    ┌──────────────────────┐
    │  limits_override     │  تجاوزات لحساب محدد
    │                      │
    │ account_id (FK, PK)  │
    │ mode                 │
    │ per_day/week/month   │
    └────────┬─────────────┘
             │
             ▼
    ┌──────────────────┐
    │ steam_accounts   │
    └──────────────────┘
```

### أولوية الحدود:
1. **limits_override** (حساب محدد)
2. **limits_bot** (بوت محدد)
3. **limits_global** (افتراضي)

---

## 🔗 مفاتيح خارجية (Foreign Keys)

| الجدول | العمود | يشير إلى |
|--------|--------|----------|
| `group_accounts` | `group_id` | `account_groups.id` |
| `group_accounts` | `account_id` | `steam_accounts.id` |
| `bot_groups` | `bot_id` | `sub_bots.id` |
| `bot_groups` | `group_id` | `account_groups.id` |
| `bot_message_templates` | `bot_id` | `sub_bots.id` |
| `limit_counters` | `account_id` | `steam_accounts.id` |
| `limit_bans` | `account_id` | `steam_accounts.id` |
| `limits_override` | `account_id` | `steam_accounts.id` |
| `voucher_usage` | `bot_id` | `sub_bots.id` |

---

## 🎨 الخريطة الكاملة (مبسطة)

```
                  ┌──────────────────┐
                  │ account_groups   │
                  └────────┬─────────┘
                           │
          ┌────────────────┼────────────────┐
          │                                 │
          ▼                                 ▼
┌──────────────────┐             ┌──────────────────┐
│ steam_accounts   │             │   sub_bots       │
└────────┬─────────┘             └────────┬─────────┘
         │                                │
         ├─► limit_counters               ├─► allowed_users
         ├─► limit_bans                   ├─► bot_message_templates
         ├─► limits_override              ├─► voucher_usage
         └─► steam_requests               └─► broadcast_*
```

---

## 📋 ملخص العلاقات

### علاقات many-to-many (كثير لكثير):
- `steam_accounts` ↔ `account_groups` (عبر `group_accounts`)
- `sub_bots` ↔ `account_groups` (عبر `bot_groups`)

### علاقات one-to-many (واحد لكثير):
- `steam_accounts` → `limit_counters`
- `steam_accounts` → `limit_bans`
- `steam_accounts` → `limits_override`
- `sub_bots` → `allowed_users`
- `sub_bots` → `bot_message_templates`
- `sub_bots` → `voucher_usage`

---

## 🔄 كيف يعمل النظام؟

### 1. البوت يطلب حساباً

```
البوت (sub_bots)
    ↓
يتحقق من allowed_users (هل المستخدم مصرح؟)
    ↓
يجلب المجموعات المربوطة (bot_groups)
    ↓
يحصل على الحسابات من المجموعات (group_accounts)
    ↓
يتحقق من الحدود (limit_counters)
    ↓
يعطي الكود
```

### 2. نظام الحدود

```
طلب كود
    ↓
تحقق من limits_override (حساب محدد؟)
    ↓ لا
تحقق من limits_bot (بوت محدد؟)
    ↓ لا
استخدم limits_global (افتراضي)
    ↓
تحقق من limit_counters (استهلك الحد؟)
    ↓ نعم
رسالة من limit_messages
```

---

*آخر تحديث: 2025-10-25 04:20 UTC+03*
