<?php
/**
 * فحص ما إذا كان الأمر /responses موجود في الكود
 */

$file = __DIR__ . '/control_bot.php';
$content = file_get_contents($file);

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>فحص الأمر</title>
    <style>
        body { font-family: Arial; padding: 20px; }
        .success { color: green; font-weight: bold; }
        .error { color: red; font-weight: bold; }
        .code { background: #f5f5f5; padding: 10px; border: 1px solid #ddd; margin: 10px 0; direction: ltr; }
    </style>
</head>
<body>
    <h1>🔍 فحص الأمر /responses</h1>
    <hr>
    
    <?php
    // 1. هل الأمر موجود؟
    echo "<h2>1️⃣ هل case '/responses': موجود؟</h2>";
    if (strpos($content, "case '/responses':") !== false) {
        echo "<p class='success'>✅ نعم، موجود!</p>";
        
        // استخراج الكود
        $start = strpos($content, "case '/responses':");
        $end = strpos($content, 'break;', $start);
        $code = substr($content, $start, $end - $start + 10);
        
        echo "<div class='code'><pre>" . htmlspecialchars($code) . "</pre></div>";
        
        // عد الأسطر
        $lines = substr_count($code, "\n");
        echo "<p>عدد الأسطر: {$lines}</p>";
        
    } else {
        echo "<p class='error'>❌ لا، غير موجود!</p>";
    }
    
    // 2. هل يوجد try/catch؟
    echo "<h2>2️⃣ هل يوجد معالجة أخطاء (try/catch)؟</h2>";
    if (strpos($content, "case '/responses':") !== false) {
        $start = strpos($content, "case '/responses':");
        $section = substr($content, $start, 1000);
        
        if (strpos($section, 'try {') !== false) {
            echo "<p class='success'>✅ نعم، يوجد try/catch</p>";
        } else {
            echo "<p class='error'>❌ لا يوجد try/catch</p>";
        }
    }
    
    // 3. هل يوجد tg_send؟
    echo "<h2>3️⃣ هل يوجد tg_send في الأمر؟</h2>";
    if (strpos($content, "case '/responses':") !== false) {
        $start = strpos($content, "case '/responses':");
        $end = strpos($content, 'break;', $start);
        $section = substr($content, $start, $end - $start);
        
        $count = substr_count($section, 'tg_send');
        echo "<p class='success'>✅ عدد tg_send: {$count}</p>";
    }
    
    // 4. فحص الأوامر الأخرى
    echo "<h2>4️⃣ فحص أوامر أخرى (للمقارنة):</h2>";
    $test_commands = ['/start', '/help', '/list', '/accounts'];
    
    echo "<table border='1' cellpadding='10'>";
    echo "<tr><th>الأمر</th><th>موجود؟</th></tr>";
    foreach ($test_commands as $cmd) {
        $exists = strpos($content, "case '{$cmd}':") !== false;
        $status = $exists ? "<span class='success'>✅</span>" : "<span class='error'>❌</span>";
        echo "<tr><td>{$cmd}</td><td>{$status}</td></tr>";
    }
    echo "</table>";
    
    // 5. فحص switch statement
    echo "<h2>5️⃣ فحص بنية switch:</h2>";
    $switch_count = substr_count($content, 'switch (');
    echo "<p>عدد switch statements: {$switch_count}</p>";
    
    if (preg_match('/switch\s*\(\$cmd\)\s*{/', $content)) {
        echo "<p class='success'>✅ switch (\$cmd) موجود</p>";
    } else {
        echo "<p class='error'>❌ switch (\$cmd) غير موجود!</p>";
    }
    
    // 6. موقع الأمر
    echo "<h2>6️⃣ موقع الأمر في الملف:</h2>";
    if (strpos($content, "case '/responses':") !== false) {
        $pos = strpos($content, "case '/responses':");
        $lines_before = substr_count(substr($content, 0, $pos), "\n");
        echo "<p>رقم السطر التقريبي: ~{$lines_before}</p>";
    }
    
    ?>
    
    <hr>
    <h2>✅ الخلاصة:</h2>
    <p>إذا كان الأمر موجود ومعالجة الأخطاء موجودة، المشكلة قد تكون:</p>
    <ul>
        <li>الأمر يصل لكن يحدث exception صامت</li>
        <li>tg_send يفشل بدون رسالة خطأ</li>
        <li>المشكلة في webhook</li>
    </ul>
    
    <p><strong>الحل:</strong> جرّب test_responses.php لاختبار مباشر</p>
</body>
</html>
