﻿# 🚀 Quick Start Guide: Groups & Vouchers Enhancement

## ⚡ 3 Steps to Deploy

### Step 1: Apply Database Migration (2 min)

```bash
cd /path/to/project
mysql -u youruser -p yourdatabase < MIGRATION_GROUPS_VOUCHERS.sql
```

**Expected Output:**
```
✅ Column locked already exists (or added)
✅ Unique index already exists (or created)  
✅ Table voucher_usage created
✅ Migration completed successfully!
```

---

### Step 2: Upload PHP Files (1 min)

```bash
# Upload modified files
scp control_bot.php user@server:/var/www/project/
scp lib/help_content.php user@server:/var/www/project/lib/
```

---

### Step 3: Test in Telegram (2 min)

```
1. /help groups           ← Verify new commands appear
2. /group_lock default    ← Test lock
3. /group_usage default   ← Test usage stats
4. /group_unlock default  ← Test unlock
```

---

## 📋 New Commands Cheat Sheet

### Groups Management

| Command | Usage | Example |
|---------|-------|---------|
| `/group_rename` | `old new` | `/group_rename vip premium` |
| `/group_delete` | `name confirm` | `/group_delete old confirm` |
| `/group_lock` | `name` | `/group_lock vip` |
| `/group_unlock` | `name` | `/group_unlock vip` |
| `/group_usage` | `name` | `/group_usage vip` |
| `/bot_groups` | `bot` | `/bot_groups mybot` |

### Accounts (Batch)

| Command | Usage | Example |
|---------|-------|---------|
| `/group_account_add` | `group acc1 acc2 ...` | `/group_account_add vip a1 a2 a3` |
| `/group_account_del` | `group acc1 acc2 ...` | `/group_account_del vip a1 a2` |

### Vouchers

| Command | Usage | Example |
|---------|-------|---------|
| `/voucher_who_used` | `code` | `/voucher_who_used ABC123` |

---

## 🎯 Common Use Cases

### Use Case 1: Protect Important Groups

```
/group_lock default
/group_lock vip
```
→ Now these groups cannot be renamed or deleted accidentally

---

### Use Case 2: Add Multiple Accounts Quickly

```
/group_account_add premium acc1 acc2 acc3 acc4 acc5
```
→ Summary: Added: 5, Skipped: 0, NotFound: 0

---

### Use Case 3: See What Accounts a Bot Can Access

```
/bot_groups mybot
```
→ Shows all groups + UNION of all visible accounts

---

### Use Case 4: Track Who Used a Voucher

```
/voucher_who_used PROMO2024
```
→ Shows which bots redeemed it + timestamps

---

## ⚠️ Important Notes

1. **Locked Groups:**
   - ❌ Cannot rename
   - ❌ Cannot delete
   - ✅ Can still bind/unbind bots
   - ✅ Can still add/remove accounts

2. **Default Groups:**
   - Cannot be deleted (even if unlocked)
   - Should always stay locked

3. **Batch Operations:**
   - Continue on error (don't stop at first failure)
   - Return summary at end
   - Safe to run multiple times

4. **Case Sensitivity:**
   - Group names are case-insensitive
   - `vip` = `VIP` = `Vip`

---

## 🆘 Troubleshooting

### Migration fails with "column already exists"

✅ **This is OK!** The migration is idempotent. It means you already ran it before.

### Cannot rename group

Check if it's locked:
```
/groups_list  ← Look for 🔒 icon
/group_unlock <name>
```

### Cannot delete group

Possible reasons:
1. Group is locked → `/group_unlock`
2. Group is default → Cannot delete
3. Group has bot links → `/group_unbind` first

### Voucher tracking not working

Make sure `voucher_usage` table exists:
```sql
SHOW TABLES LIKE 'voucher_usage';
```

---

## 📖 Full Documentation

See `GROUPS_VOUCHERS_REPORT.md` for complete details.

---

**Happy Managing! 🎉**
