-- ================================================================
-- تحديث رسائل المساعدة في message_templates
-- ================================================================
-- التاريخ: 2025-10-25
-- الهدف: تحديث قسم القسائم وإضافة قسم حدود البوتات المتقدمة
-- ================================================================

-- 1. تحديث قسم القسائم (help_part5)
UPDATE `message_templates` 
SET `text` = '🎫 <b>قسم القسائم</b> 🆕

💡 <i>لزيادة حدود المستخدمين أو إضافة أيام</i>

<b>/generate_voucher</b> <code>type amount [bot] [uses]</code>
➡️ إنشاء قسيمة جديدة

<b>الأنواع:</b> users | days

💡 <code>/generate_voucher users 100 mybot 1</code>
💡 <code>/generate_voucher users 50 all 5</code>

<b>/redeem</b> <code>code [bot]</code> - تفعيل قسيمة
💡 <code>/redeem ABC123 mybot</code>

<b>/vouchers</b> - عرض جميع القسائم
<b>/voucher_search</b> <code>code</code> - بحث عن قسيمة

<b>/voucher_who_used</b> <code>code</code> - تقرير الاستخدام 🆕
💡 <code>/voucher_who_used ABC123</code>
➡️ يعرض البوتات التي استخدمت القسيمة مع التواريخ

<b>/voucher_delete</b> <code>code</code> - حذف قسيمة نهائياً 🆕
💡 <code>/voucher_delete ABC123</code>
⚠️ لا يمكن التراجع!

<b>/voucher_stats</b> - إحصائيات القسائم 🆕
📊 يعرض: إجمالي القسائم، المستخدمة، المتبقية، معدل الاستخدام'
WHERE `key` = 'help_part5';

-- 2. تحديث قسم الحدود الذكي (help_part9) مع إضافة حدود البوتات المتقدمة
UPDATE `message_templates` 
SET `text` = '🎯 <b>نظام الحدود الذكي</b> 🆕✨

💡 <i>نظام متقدم مع 3 أوضاع: يومي/أسبوعي/شهري</i>

<b>🌍 الحدود العامة:</b>
<b>/limit_mode_all</b> <code>mode</code>
➡️ تغيير الوضع العام (daily/weekly/monthly)
💡 <code>/limit_mode_all weekly</code>

<b>/set_daily_all</b> <code>per_day</code>
➡️ تعيين حد يومي عام
💡 <code>/set_daily_all 3</code>

<b>/set_weekly_all</b> <code>per_day weekly_cap ban_days</code>
➡️ حد أسبوعي: يومي + سقف أسبوعي + مدة حظر
💡 <code>/set_weekly_all 2 6 7</code>

<b>/set_monthly_all</b> <code>per_day monthly_cap ban_days</code>
➡️ حد شهري: يومي + سقف شهري + مدة حظر
💡 <code>/set_monthly_all 2 20 30</code>

<b>🤖 حدود البوتات (متقدمة):</b> ✨
<b>/limit_mode</b> <code>bot mode</code>
➡️ تعيين وضع خاص لبوت محدد
💡 <code>/limit_mode mybot weekly</code>

<b>/set_daily</b> <code>bot per_day</code> 🆕
➡️ حد يومي دقيق لبوت محدد
💡 <code>/set_daily testbot 1</code>

<b>/set_weekly</b> <code>bot per_day cap ban</code> 🆕
➡️ حد أسبوعي دقيق لبوت محدد
💡 <code>/set_weekly vipbot 5 20 3</code>

<b>/set_monthly</b> <code>bot per_day cap ban</code> 🆕
➡️ حد شهري دقيق لبوت محدد
💡 <code>/set_monthly premiumbot 10 100 7</code>

<b>/bot_limit_clear</b> <code>bot</code> 🆕
➡️ حذف الحدود الخاصة (العودة للعامة)
💡 <code>/bot_limit_clear testbot</code>

<b>👤 التجاوز (حدود خاصة):</b>
<b>/override_account</b> <code>id mode per_day [cap] [ban]</code>
➡️ حدود مخصصة لحساب محدد (أعلى أولوية)
💡 <code>/override_account 5 weekly 3 10 7</code>

<b>/override_clear</b> <code>id</code> - حذف التجاوز

<b>📊 الاستعلام (محدّث):</b> ✨
<b>/show_limit</b> <code>target</code>
➡️ عرض الحدود (global/bot/bot/label/account_id)
💡 <code>/show_limit global</code>
💡 <code>/show_limit bot</code> - جميع البوتات 🆕
💡 <code>/show_limit bot/vipbot</code> - بوت محدد 🆕
💡 <code>/show_limit vipbot</code> - بوت محدد
💡 <code>/show_limit 5</code> - حساب محدد

<b>/reset_counters</b> <code>target</code>
➡️ إعادة تعيين العدادات (user_id/all)
💡 <code>/reset_counters 123456789</code>

<b>⛔ الحظر:</b>
<b>/ban_from_account</b> <code>user_id account_id days</code>
➡️ حظر مستخدم من حساب لمدة محددة
💡 <code>/ban_from_account 123456789 5 7</code>

<b>/unban_from_account</b> <code>user_id account_id</code>
➡️ إلغاء حظر مستخدم من حساب

<b>💬 الرسائل:</b>
<b>/msg_set</b> <code>event text</code> - تخصيص رسالة
<b>/msg_show</b> - عرض جميع الرسائل

<b>📝 الأوضاع:</b>
• <b>daily:</b> 2 كود/يوم (رفض فوري)
• <b>weekly:</b> 2 كود/يوم + 6/أسبوع (حظر 7 أيام)
• <b>monthly:</b> 2 كود/يوم + 20/شهر (حظر 30 يوم)

<b>🎯 الأولوية:</b>
override → bot → global'
WHERE `key` = 'help_part9';

-- 3. إضافة قسم جديد (help_part10) للأمثلة العملية
INSERT INTO `message_templates` (`key`, `text`) VALUES
('help_part10', '💡 <b>أمثلة عملية - حدود البوتات</b> ✨

<b>مثال 1: بوت VIP بحدود أعلى</b>
<code>/set_weekly vipbot 5 20 3</code>
✅ 5 كود/يوم، 20/أسبوع، حظر 3 أيام فقط

<b>مثال 2: بوت تجريبي بحد منخفض</b>
<code>/set_daily testbot 1</code>
✅ كود واحد يومياً، رفض فوري بعدها

<b>مثال 3: بوت متميز بحد شهري</b>
<code>/set_monthly premiumbot 10 100 7</code>
✅ 10 كود/يوم، 100/شهر، حظر 7 أيام

<b>مثال 4: عرض جميع البوتات وحدودها</b>
<code>/show_limit bot</code>
✅ قائمة كاملة بالبوتات وحدودها الخاصة والعامة

<b>مثال 5: عرض بوت محدد</b>
<code>/show_limit vipbot</code>
<code>/show_limit bot/vipbot</code>
✅ عرض تفصيلي لحدود البوت

<b>مثال 6: حذف حدود خاصة</b>
<code>/bot_limit_clear testbot</code>
✅ يعود البوت لاستخدام الحدود العامة

<b>مثال 7: حساب VIP بحدود خاصة</b>
<code>/override_account 5 weekly 10 50 1</code>
✅ 10 كود/يوم، 50/أسبوع، حظر يوم واحد فقط

━━━━━━━━━━━━━━━━━
💡 <b>نصائح:</b>
• استخدم <code>/show_limit bot</code> لمراجعة جميع الحدود
• البوتات بدون حدود خاصة تستخدم الحدود العامة تلقائياً
• يمكنك تغيير حدود أي بوت في أي وقت
• الأولوية: override > bot > global')
ON DUPLICATE KEY UPDATE `text` = VALUES(`text`);

-- 4. تأكيد التحديث
SELECT 'تم تحديث رسائل المساعدة بنجاح! ✅' as status;

-- ================================================================
-- ملاحظات التطبيق:
-- ================================================================
-- 1. قم بتشغيل هذا الملف في phpMyAdmin أو MySQL CLI
-- 2. تأكد من اختيار قاعدة البيانات الصحيحة (supehgku_test0)
-- 3. التحديثات آمنة ولن تؤثر على البيانات الموجودة
-- 4. يمكن تشغيل الملف عدة مرات بأمان (idempotent)
-- ================================================================

-- للتطبيق المباشر:
-- mysql -u username -p supehgku_test0 < update_help_messages.sql

-- أو في phpMyAdmin:
-- 1. افتح قاعدة البيانات supehgku_test0
-- 2. اذهب إلى تبويب SQL
-- 3. انسخ والصق هذا الكود
-- 4. اضغط تنفيذ (Go)
