-- ================================================================
-- إعادة تسمية البوتات من أرقام إلى أسماء واضحة
-- ================================================================
-- المشكلة: استخدام '1', '2', '3' كأسماء يسبب تضارب مع account_id
-- الحل: إعادة التسمية إلى test1, test2, test3
-- ================================================================

-- 1. عرض البوتات الحالية
SELECT 
    id, 
    label as 'الاسم الحالي',
    CONCAT('test', id - 26) as 'الاسم الجديد'
FROM sub_bots 
WHERE id IN (27, 28, 29);

-- 2. إعادة تسمية البوتات
UPDATE sub_bots SET label = 'test1' WHERE id = 27;
UPDATE sub_bots SET label = 'test2' WHERE id = 28;
UPDATE sub_bots SET label = 'test3' WHERE id = 29;

-- 3. تحديث حدود البوتات (إذا كانت موجودة)
UPDATE limits_bot SET bot_label = 'test1' WHERE bot_label = '1';
UPDATE limits_bot SET bot_label = 'test2' WHERE bot_label = '2';
UPDATE limits_bot SET bot_label = 'test3' WHERE bot_label = '3';

-- 4. التحقق من النتيجة
SELECT 'تم إعادة التسمية بنجاح! ✅' as status;

SELECT 
    sb.id,
    sb.label as 'اسم البوت',
    lb.mode as 'الوضع',
    lb.per_day as 'يومي',
    CASE 
        WHEN lb.bot_label IS NOT NULL THEN 'حدود خاصة ✅'
        ELSE 'حدود عامة 🌍'
    END as 'نوع الحدود'
FROM sub_bots sb
LEFT JOIN limits_bot lb ON lb.bot_label = sb.label
WHERE sb.id IN (27, 28, 29);

-- ================================================================
-- بعد التطبيق، يمكنك استخدام:
-- ================================================================
-- /show_limit test1        ← ✅ يعمل مباشرة
-- /set_daily test1 5       ← ✅ واضح وسهل
-- /show_limit bot          ← ✅ عرض جميع البوتات
-- ================================================================
