-- ================================================================
-- الفحص التلقائي والإصلاح
-- ================================================================
-- نفّذ هذا الملف بالكامل - سيتحقق ويطبق فقط ما هو مطلوب
-- ================================================================

-- ═══════════════════════════════════════════════════════════════
-- الخطوة 1: التحقق من limit_counters
-- ═══════════════════════════════════════════════════════════════

-- هل bot_label موجود؟
SELECT 
    CASE 
        WHEN COUNT(*) > 0 THEN '✅ bot_label موجود في limit_counters'
        ELSE '❌ bot_label غير موجود - يحتاج إضافة'
    END as 'الحالة'
FROM INFORMATION_SCHEMA.COLUMNS 
WHERE TABLE_SCHEMA = DATABASE() 
  AND TABLE_NAME = 'limit_counters'
  AND COLUMN_NAME = 'bot_label';

-- هل المفتاح الجديد موجود؟
SELECT 
    CASE 
        WHEN COUNT(*) > 0 THEN '✅ المفتاح unique_user_account_bot موجود'
        ELSE '❌ المفتاح غير موجود - يحتاج إضافة'
    END as 'الحالة'
FROM INFORMATION_SCHEMA.STATISTICS 
WHERE TABLE_SCHEMA = DATABASE() 
  AND TABLE_NAME = 'limit_counters'
  AND INDEX_NAME = 'unique_user_account_bot';

-- هل هناك سجلات بدون bot_label؟
SELECT 
    COUNT(*) as 'عدد السجلات بدون bot_label',
    CASE 
        WHEN COUNT(*) > 0 THEN '⚠️ يحتاج تحديث'
        ELSE '✅ لا يحتاج تحديث'
    END as 'الحالة'
FROM limit_counters 
WHERE bot_label IS NULL OR bot_label = '';

-- ═══════════════════════════════════════════════════════════════
-- الخطوة 2: التحقق من limit_bans
-- ═══════════════════════════════════════════════════════════════

-- هل bot_label موجود؟
SELECT 
    CASE 
        WHEN COUNT(*) > 0 THEN '✅ bot_label موجود في limit_bans'
        ELSE '❌ bot_label غير موجود - يحتاج إضافة'
    END as 'الحالة'
FROM INFORMATION_SCHEMA.COLUMNS 
WHERE TABLE_SCHEMA = DATABASE() 
  AND TABLE_NAME = 'limit_bans'
  AND COLUMN_NAME = 'bot_label';

-- هل المفتاح الجديد موجود؟
SELECT 
    CASE 
        WHEN COUNT(*) > 0 THEN '✅ المفتاح unique_user_account_bot_ban موجود'
        ELSE '❌ المفتاح غير موجود - يحتاج إضافة'
    END as 'الحالة'
FROM INFORMATION_SCHEMA.STATISTICS 
WHERE TABLE_SCHEMA = DATABASE() 
  AND TABLE_NAME = 'limit_bans'
  AND INDEX_NAME = 'unique_user_account_bot_ban';

-- ═══════════════════════════════════════════════════════════════
-- الخطوة 3: قائمة الإصلاحات المطلوبة
-- ═══════════════════════════════════════════════════════════════

-- بناءً على النتائج أعلاه، نفّذ الأوامر التالية حسب الحاجة:

-- ────────────────────────────────────────────────────────────────
-- إذا قال "bot_label غير موجود في limit_counters"
-- ────────────────────────────────────────────────────────────────
-- انسخ ونفّذ:

-- START TRANSACTION;
-- ALTER TABLE `limit_counters` ADD COLUMN `bot_label` VARCHAR(50) NULL AFTER `account_id`;
-- ALTER TABLE `limit_counters` ADD INDEX `idx_bot_counters` (`bot_label`);
-- UPDATE `limit_counters` SET `bot_label` = 'test1' WHERE `bot_label` IS NULL;
-- ALTER TABLE `limit_counters` MODIFY `bot_label` VARCHAR(50) NOT NULL COMMENT 'تسمية البوت';
-- COMMIT;

-- ────────────────────────────────────────────────────────────────
-- إذا قال "bot_label موجود" لكن "يحتاج تحديث"
-- ────────────────────────────────────────────────────────────────
-- انسخ ونفّذ:

-- UPDATE `limit_counters` SET `bot_label` = 'test1' WHERE `bot_label` IS NULL OR `bot_label` = '';

-- ────────────────────────────────────────────────────────────────
-- إذا قال "المفتاح غير موجود"
-- ────────────────────────────────────────────────────────────────
-- انسخ ونفّذ:

-- START TRANSACTION;
-- ALTER TABLE `limit_counters` DROP INDEX IF EXISTS `unique_user_account`;
-- ALTER TABLE `limit_counters` ADD UNIQUE KEY `unique_user_account_bot` (`user_id`, `account_id`, `bot_label`);
-- ALTER TABLE `limit_counters` ADD CONSTRAINT `fk_counters_bot_label` FOREIGN KEY (`bot_label`) REFERENCES `sub_bots`(`label`) ON UPDATE CASCADE ON DELETE CASCADE;
-- COMMIT;

-- ────────────────────────────────────────────────────────────────
-- نفس الشيء لـ limit_bans
-- ────────────────────────────────────────────────────────────────

-- إذا قال "bot_label غير موجود في limit_bans":
-- START TRANSACTION;
-- ALTER TABLE `limit_bans` ADD COLUMN `bot_label` VARCHAR(50) NULL AFTER `account_id`;
-- ALTER TABLE `limit_bans` ADD INDEX `idx_bot_bans` (`bot_label`);
-- UPDATE `limit_bans` SET `bot_label` = 'test1' WHERE `bot_label` IS NULL;
-- ALTER TABLE `limit_bans` MODIFY `bot_label` VARCHAR(50) NOT NULL COMMENT 'تسمية البوت';
-- COMMIT;

-- إذا قال "المفتاح غير موجود في limit_bans":
-- START TRANSACTION;
-- ALTER TABLE `limit_bans` DROP INDEX IF EXISTS `unique_user_account_ban`;
-- ALTER TABLE `limit_bans` ADD UNIQUE KEY `unique_user_account_bot_ban` (`user_id`, `account_id`, `bot_label`);
-- ALTER TABLE `limit_bans` ADD CONSTRAINT `fk_bans_bot_label` FOREIGN KEY (`bot_label`) REFERENCES `sub_bots`(`label`) ON UPDATE CASCADE ON DELETE CASCADE;
-- COMMIT;

-- ================================================================
-- ✅ التحقق النهائي
-- ================================================================

-- نفّذ بعد الإصلاحات:

-- DESCRIBE limit_counters;
-- DESCRIBE limit_bans;

-- يجب أن ترى bot_label في كلا الجدولين!
-- ================================================================
