# 🔧 دليل الدمج - Integration Guide

**الموضوع:** دمج نظام حدود البوتات في control_bot.php  
**التاريخ:** 2025-10-25  
**الصعوبة:** ⭐⭐ متوسط

---

## 📋 نظرة عامة

تم إنشاء نظام حدود متقدم يدعم **حدود خاصة لكل بوت**. هذا الدليل يشرح كيفية دمج الأكواد الجديدة في `control_bot.php`.

---

## ✅ ما تم إنجازه

1. ✅ **تحليل** الجداول الموجودة في قاعدة البيانات
2. ✅ **التأكد** من وجود جدول `limits_bot` (موجود ✅)
3. ✅ **تصميم** الأوامر الجديدة
4. ✅ **كتابة** الأكواد الكاملة
5. ✅ **توثيق** كل شيء

---

## 📂 الملفات المُنشأة

| الملف | الوصف | الاستخدام |
|-------|-------|-----------|
| **BOT_LIMITS_COMMANDS.md** | شرح تفصيلي للأوامر | للقراءة والفهم |
| **bot_limits_implementation.php** | الأكواد الفعلية | للنسخ واللصق |
| **INTEGRATION_GUIDE.md** | هذا الملف - دليل الدمج | للتنفيذ |

---

## 🚀 خطوات الدمج

### الخطوة 1️⃣: نسخ دالة getAppliedLimits

افتح `bot_limits_implementation.php` وانسخ الدالة:

```php
/**
 * دالة الحصول على الحدود المطبقة حسب الأولوية
 * override → bot → global
 */
function getAppliedLimits($pdo, $bot_label, $account_id = null) {
    // ... الكود الموجود في الملف
}
```

**الصق** هذه الدالة في `control_bot.php` في قسم الدوال المساعدة (Helper Functions).

**الموقع المقترح:** بعد دالة `getTemplate()` أو في بداية الملف.

---

### الخطوة 2️⃣: دمج الأوامر الجديدة

في `control_bot.php`، ابحث عن `switch ($command)` واضف الأوامر الجديدة:

#### أ) أوامر حدود البوتات:

```php
case '/limit_mode':
case '/set_daily':
case '/set_weekly':
case '/set_monthly':
case '/bot_limit_clear':
    // انسخ الكود من bot_limits_implementation.php
    break;
```

#### ب) تحديث أمر `/show_limit`:

```php
case '/show_limit':
    // استبدل الكود القديم بالكود الجديد من bot_limits_implementation.php
    break;
```

---

### الخطوة 3️⃣: تحديث منطق التحقق من الحدود

في الكود الذي يتحقق من الحدود (عند طلب كود)، استبدل:

**القديم:**
```php
// جلب الحدود العامة مباشرة
$limits = $pdo->query("SELECT * FROM limits_global WHERE id = 1")->fetch();
```

**الجديد:**
```php
// استخدام دالة getAppliedLimits
$limits = getAppliedLimits($pdo, $bot_label, $account_id);
```

**الفائدة:** الآن النظام يتحقق من الحدود حسب الأولويات تلقائياً!

---

### الخطوة 4️⃣: تحديث رسالة المساعدة

في `case '/help':` أو رسالة المساعدة، أضف الأوامر الجديدة:

```php
$help_limits = "
🎯 <b>حدود البوتات الخاصة:</b>

<b>/limit_mode</b> <code>bot mode</code>
➡️ تعيين وضع خاص لبوت (daily/weekly/monthly)
💡 <code>/limit_mode vipbot weekly</code>

<b>/set_daily</b> <code>bot per_day</code>
➡️ حد يومي بسيط لبوت
💡 <code>/set_daily testbot 3</code>

<b>/set_weekly</b> <code>bot per_day cap ban</code>
➡️ حد أسبوعي متقدم لبوت
💡 <code>/set_weekly vipbot 5 20 3</code>

<b>/set_monthly</b> <code>bot per_day cap ban</code>
➡️ حد شهري متقدم لبوت
💡 <code>/set_monthly premiumbot 10 100 7</code>

<b>/bot_limit_clear</b> <code>bot</code>
➡️ حذف الحدود الخاصة (العودة للعامة)
💡 <code>/bot_limit_clear testbot</code>

<b>/show_limit</b> <code>target</code>
➡️ عرض الحدود (global/bot/bot/label/account/id)
💡 <code>/show_limit bot/vipbot</code>
";
```

---

## 🧪 الاختبار

### اختبار 1: إنشاء حدود خاصة لبوت

```
1. /addbot testbot TOKEN @channel 100
2. /set_daily testbot 1
3. /show_limit bot/testbot
   → يجب أن يظهر: 1 كود/يوم (حدود خاصة ✅)
```

---

### اختبار 2: مقارنة الحدود

```
1. /show_limit global
   → مثلاً: 2 كود/يوم، 6/أسبوع

2. /set_weekly vipbot 5 20 3

3. /show_limit bot
   → يجب أن يظهر:
     ✅ vipbot (حدود خاصة)
     🌍 باقي البوتات (حدود عامة)
```

---

### اختبار 3: التحقق من الأولويات

```
1. /show_limit bot/normalbot
   → 2 كود/يوم (حدود عامة 🌍)

2. /set_weekly normalbot 3 15 5

3. /show_limit bot/normalbot
   → 3 كود/يوم (حدود خاصة ✅)

4. /bot_limit_clear normalbot

5. /show_limit bot/normalbot
   → 2 كود/يوم (حدود عامة 🌍 مرة أخرى)
```

---

## ⚠️ نقاط مهمة

### 1. التوافق مع الكود الموجود

الأكواد الجديدة **لا تتعارض** مع الموجود، بل تضيف ميزات جديدة:

- ✅ الحدود العامة (الموجودة) تعمل كما هي
- ✅ حدود البوتات (جديدة) تُضاف كطبقة إضافية
- ✅ التجاوزات (الموجودة) تعمل كما هي

---

### 2. الأولويات

```
override (حساب محدد)     ← أعلى أولوية
    ↓
limits_bot (بوت محدد)    ← أولوية متوسطة
    ↓
limits_global (عام)      ← أدنى أولوية
```

عند استخدام `getAppliedLimits()`:
- إذا كان هناك override للحساب → استخدمه
- وإلا إذا كان هناك حد خاص للبوت → استخدمه
- وإلا → استخدم الحد العام

---

### 3. جدول limits_bot موجود بالفعل! ✅

من تحليل قاعدة البيانات:

```sql
CREATE TABLE `limits_bot` (
  `bot_label` varchar(64) NOT NULL PRIMARY KEY,
  `mode` enum('daily','weekly','monthly') NOT NULL,
  `per_day` int(11) NOT NULL,
  `weekly_cap` int(11) DEFAULT NULL,
  `monthly_cap` int(11) DEFAULT NULL,
  `ban_days` int(11) DEFAULT NULL,
  `updated_at` timestamp
)
```

**✅ لا حاجة لإنشاء الجدول!** فقط أضف الأوامر.

---

## 📊 مثال كامل للدمج

### في control_bot.php:

```php
<?php
// ... الكود الموجود

// ====== دالة الحصول على الحدود (جديدة) ======
function getAppliedLimits($pdo, $bot_label, $account_id = null) {
    // 1️⃣ التحقق من override
    if ($account_id) {
        $stmt = $pdo->prepare("SELECT * FROM limits_override WHERE account_id = ?");
        $stmt->execute([$account_id]);
        $override = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($override) {
            return [
                'mode' => $override['mode'],
                'per_day' => $override['per_day'],
                'weekly_cap' => $override['mode'] === 'weekly' ? $override['cap'] : null,
                'monthly_cap' => $override['mode'] === 'monthly' ? $override['cap'] : null,
                'ban_days' => $override['ban_days'],
                'source' => 'override'
            ];
        }
    }
    
    // 2️⃣ التحقق من حدود البوت
    $stmt = $pdo->prepare("SELECT * FROM limits_bot WHERE bot_label = ?");
    $stmt->execute([$bot_label]);
    $bot_limit = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($bot_limit) {
        return [
            'mode' => $bot_limit['mode'],
            'per_day' => $bot_limit['per_day'],
            'weekly_cap' => $bot_limit['weekly_cap'],
            'monthly_cap' => $bot_limit['monthly_cap'],
            'ban_days' => $bot_limit['ban_days'],
            'source' => 'bot'
        ];
    }
    
    // 3️⃣ استخدام الحدود العامة
    $stmt = $pdo->query("SELECT * FROM limits_global WHERE id = 1");
    $global = $stmt->fetch(PDO::FETCH_ASSOC);
    
    return [
        'mode' => $global['mode'],
        'per_day' => $global['per_day'],
        'weekly_cap' => $global['weekly_cap'],
        'monthly_cap' => $global['monthly_cap'],
        'ban_days' => $global['ban_days'],
        'source' => 'global'
    ];
}

// ====== معالج الأوامر ======
switch ($command) {
    
    // ... الأوامر الموجودة
    
    // ====== الأوامر الجديدة ======
    
    case '/limit_mode':
        // انسخ من bot_limits_implementation.php
        break;
    
    case '/set_daily':
        // انسخ من bot_limits_implementation.php
        break;
    
    case '/set_weekly':
        // انسخ من bot_limits_implementation.php
        break;
    
    case '/set_monthly':
        // انسخ من bot_limits_implementation.php
        break;
    
    case '/bot_limit_clear':
        // انسخ من bot_limits_implementation.php
        break;
    
    case '/show_limit':
        // استبدل الكود القديم بالجديد
        break;
}

// ====== في كود طلب الكود ======
// بدلاً من:
// $limits = $pdo->query("SELECT * FROM limits_global WHERE id = 1")->fetch();

// استخدم:
$limits = getAppliedLimits($pdo, $bot_label, $account_id);

// ثم استخدم $limits كالمعتاد:
$per_day = $limits['per_day'];
$mode = $limits['mode'];
// الخ...
```

---

## ✅ قائمة التحقق

قبل الانتهاء، تأكد من:

- [ ] نسخت دالة `getAppliedLimits()`
- [ ] أضفت الأوامر الجديدة في switch
- [ ] حدّثت `/show_limit` بالكود الجديد
- [ ] استبدلت جلب الحدود بـ `getAppliedLimits()`
- [ ] حدّثت رسالة المساعدة
- [ ] اختبرت الأوامر الجديدة
- [ ] تأكدت من عدم وجود تعارضات

---

## 🎯 الخلاصة

**ما تم إنجازه:**
✅ نظام حدود خاص لكل بوت  
✅ أولويات واضحة (override → bot → global)  
✅ 6 أوامر جديدة  
✅ تحديث `/show_limit` ليدعم البوتات  
✅ دالة `getAppliedLimits()` ذكية  
✅ لا تعارضات مع الموجود  

**النتيجة:**
🎉 نظام حدود متقدم ومرن يناسب جميع الاحتياجات!

---

*آخر تحديث: 2025-10-25*  
*جاهز للدمج: ✅ نعم*
