# 🎯 دليل عزل الحدود لكل بوت (Bot Isolation)

**التاريخ:** 2025-10-25  
**الإصدار:** 2.0  
**الحالة:** جاهز للتطبيق

---

## 📊 المشكلة

### ❌ السلوك الحالي (قبل التحديث):

```
المستخدم: 5458195623
الحساب: wastefulstupidlapwing (account_id=106)

في test1:
- حصل على 7 أكواد
- العداد في limit_counters: day_used=7

في test2:
- يستخدم نفس العداد!
- day_used=7 بالفعل
```

**النتيجة:** العدادات **مشتركة** بين جميع البوتات!

---

## ✅ الحل: إضافة bot_label

### البنية الجديدة:

#### 1. limit_counters:
```sql
-- قبل:
UNIQUE KEY (user_id, account_id)

-- بعد:
UNIQUE KEY (user_id, account_id, bot_label) ✅
```

#### 2. limit_bans:
```sql
-- قبل:
UNIQUE KEY (user_id, account_id)

-- بعد:
UNIQUE KEY (user_id, account_id, bot_label) ✅
```

---

## 🎯 النتيجة النهائية

### السلوك الجديد:

```
المستخدم: 5458195623
الحساب: wastefulstupidlapwing (account_id=106)

في test1:
- day_used=7 (bot_label='test1')
- حد test1: 2 كود/يوم → مرفوض ✅

في test2:
- day_used=0 (bot_label='test2') ← عداد جديد مستقل!
- حد test2: 5 كود/يوم → مسموح ✅

في test3:
- day_used=0 (bot_label='test3') ← عداد جديد مستقل!
- حد test3: 10 كود/يوم → مسموح ✅
```

**كل بوت له عداداته المستقلة!** 🎉

---

## 📋 خطوات التطبيق

### الخطوة 1: تحديث قاعدة البيانات

```sql
-- في phpMyAdmin:
-- نفّذ الملف: COMPLETE_FIX_BOT_ISOLATION.sql
```

**ماذا يفعل:**
1. يضيف عمود `bot_label` إلى `limit_counters`
2. يضيف عمود `bot_label` إلى `limit_bans`
3. يحدث المفاتيح الفريدة
4. يضيف foreign keys
5. يملأ السجلات الموجودة بـ `'test1'`

**المدة:** ~10 ثواني

---

### الخطوة 2: رفع الملفات المحدثة

```bash
# الملفات المحدثة:
lib/limits.php         ← محدث ✅
lib/limits_core.php    ← محدث ✅
```

**التغييرات في الكود:**

#### في limits.php:

```php
// قبل:
function get_or_create_counter(PDO $db, int $user_id, int $account_id): array

// بعد:
function get_or_create_counter(PDO $db, int $user_id, int $account_id, string $bot_label): array
```

```php
// قبل:
function check_ban(PDO $db, int $user_id, int $account_id): ?array

// بعد:
function check_ban(PDO $db, int $user_id, int $account_id, string $bot_label): ?array
```

```php
// قبل:
function apply_ban(PDO $db, int $user_id, int $account_id, int $days, ...): void

// بعد:
function apply_ban(PDO $db, int $user_id, int $account_id, string $bot_label, int $days, ...): void
```

#### في limits_core.php:

```php
// قبل:
$ban = check_ban($db, $user_id, $account_id);
$counter = get_or_create_counter($db, $user_id, $account_id);
apply_ban($db, $user_id, $account_id, $ban_days, 'weekly_exceeded');

// بعد:
$ban = check_ban($db, $user_id, $account_id, $bot_label);
$counter = get_or_create_counter($db, $user_id, $account_id, $bot_label);
apply_ban($db, $user_id, $account_id, $bot_label, $ban_days, 'weekly_exceeded');
```

---

### الخطوة 3: اختبار النظام

```
1. في البوت المركزي:

/set_daily test1 2
/set_daily test2 5
/set_daily test3 10

2. في البوت test1:

wastefulstupidlapwing → ✅ كود (1/2)
wastefulstupidlapwing → ✅ كود (2/2)
wastefulstupidlapwing → ❌ رفض (تجاوز)

3. في البوت test2 (نفس المستخدم):

wastefulstupidlapwing → ✅ كود (1/5) ← عداد جديد!
wastefulstupidlapwing → ✅ كود (2/5)
...
```

---

## 🔍 التحقق من النجاح

### في قاعدة البيانات:

```sql
-- عرض العدادات لمستخدم معين
SELECT 
    lc.user_id,
    lc.account_id,
    lc.bot_label,
    lc.day_used,
    sb.label as bot_name
FROM limit_counters lc
JOIN sub_bots sb ON sb.label = lc.bot_label
WHERE lc.user_id = 5458195623
ORDER BY lc.bot_label;
```

**النتيجة المتوقعة:**
```
user_id      | account_id | bot_label | day_used | bot_name
5458195623   | 106        | test1     | 2        | test1
5458195623   | 106        | test2     | 2        | test2
5458195623   | 106        | test3     | 0        | test3
```

**كل بوت له عداد مستقل!** ✅

---

## 📊 مقارنة قبل وبعد

| الميزة | قبل التحديث ❌ | بعد التحديث ✅ |
|--------|----------------|----------------|
| **العدادات** | مشتركة بين البوتات | مستقلة لكل بوت |
| **الحظر** | عام على جميع البوتات | مستقل لكل بوت |
| **المرونة** | محدودة | عالية |
| **الدقة** | منخفضة | عالية |

---

## 🎯 حالات الاستخدام

### حالة 1: بوتات بحدود مختلفة

```
test1 (مجاني):    2 كود/يوم
test2 (برونز):     5 كود/يوم
test3 (VIP):      50 كود/يوم
```

المستخدم يمكنه استخدام نفس الحساب في **جميع البوتات** بشكل منفصل!

---

### حالة 2: حظر في بوت واحد

```
test1 → محظور (تجاوز الحد الأسبوعي)
test2 → غير محظور (مستقل)
test3 → غير محظور (مستقل)
```

الحظر **لا ينتقل** بين البوتات!

---

### حالة 3: إعادة تعيين لبوت واحد

```sql
-- إعادة تعيين عدادات test1 فقط
UPDATE limit_counters 
SET day_used = 0, week_used = 0, month_used = 0 
WHERE bot_label = 'test1';
```

البوتات الأخرى **لا تتأثر**!

---

## ⚠️ ملاحظات مهمة

### 1. السجلات القديمة:

الملف `COMPLETE_FIX_BOT_ISOLATION.sql` يعيّن جميع السجلات القديمة إلى `'test1'`.

**إذا كنت تريد حذفها:**
```sql
-- بدلاً من:
UPDATE limit_counters SET bot_label = 'test1' WHERE bot_label IS NULL;

-- استخدم:
DELETE FROM limit_counters WHERE bot_label IS NULL;
```

---

### 2. التوافق مع الإصدارات القديمة:

هذا التحديث **غير متوافق** مع الإصدارات القديمة.

**يجب:**
- تحديث قاعدة البيانات
- رفع `lib/limits.php` و `lib/limits_core.php` المحدثة
- **معاً في نفس الوقت**

---

### 3. النسخ الاحتياطي:

```sql
-- قبل التطبيق، اعمل backup:
CREATE TABLE limit_counters_backup AS SELECT * FROM limit_counters;
CREATE TABLE limit_bans_backup AS SELECT * FROM limit_bans;
```

---

## 🚀 الخلاصة

### ما تم إصلاحه:

1. ✅ **العدادات مستقلة** لكل بوت
2. ✅ **الحظر مستقل** لكل بوت
3. ✅ **دقة أعلى** في الحدود
4. ✅ **مرونة أكبر** في الإدارة

### الملفات المطلوبة:

1. **SQL:** `COMPLETE_FIX_BOT_ISOLATION.sql`
2. **PHP:** `lib/limits.php` (محدث)
3. **PHP:** `lib/limits_core.php` (محدث)

### خطوات التطبيق:

1. نفّذ SQL في phpMyAdmin
2. ارفع الملفات المحدثة
3. اختبر في البوتات الفرعية
4. ✅ تم!

---

**🎉 الآن كل بوت له نظام حدود مستقل تماماً!**

---

*آخر تحديث: 2025-10-25 16:45 UTC+03*
