# 📘 دليل دمج الأوامر الجديدة

**التاريخ:** 2025-10-25  
**الملفات المطلوبة:** 3 ملفات

---

## 📋 الأوامر الجديدة

### 1. قسم إدارة البوتات:
- **`/bot_rename`** - تعديل اسم بوت

### 2. قسم المجموعات:
- **`/group_details`** - استعلام تفصيلي عن مجموعة (البوتات والحسابات)
- **`/bot_details`** - استعلام تفصيلي عن بوت (المجموعات والحسابات)

### 3. قسم الحسابات:
- **`/account_details`** - استعلام تفصيلي عن حساب (البوت، المجموعة، الحدود)

---

## 🚀 خطوات التطبيق

### الخطوة 1: تحديث قاعدة البيانات

```bash
# في phpMyAdmin:
# نفّذ الملف: UPDATE_COMMANDS_MESSAGES.sql
```

**ماذا يفعل:**
- يضيف قوالب الرسائل للأوامر الجديدة في `message_templates`
- يحدث الرسائل الموجودة

---

### الخطوة 2: دمج الأوامر في control_bot.php

#### أين تضيف الأوامر:

```php
// control_bot.php
// حوالي السطر 2500 (قبل default case)

// ════════════════════════════════════════════════════════════
// الأوامر الجديدة - إدارة متقدمة
// ════════════════════════════════════════════════════════════

case '/bot_rename': {
    // ... انسخ الكود من NEW_COMMANDS.php
    break;
}

case '/group_details': {
    // ... انسخ الكود من NEW_COMMANDS.php
    break;
}

case '/bot_details': {
    // ... انسخ الكود من NEW_COMMANDS.php
    break;
}

case '/account_details': {
    // ... انسخ الكود من NEW_COMMANDS.php
    break;
}

// ════════════════════════════════════════════════════════════

        default: {
            // ... الكود الموجود
        }
```

#### كيفية الدمج:

1. افتح `control_bot.php`
2. ابحث عن `default: {` في switch statement
3. قبله مباشرة، الصق محتوى `NEW_COMMANDS.php`
4. احفظ الملف

---

### الخطوة 3: تحديث رسالة المساعدة

أضف الأوامر الجديدة إلى رسالة `/help`:

```php
// في دالة المساعدة أو قسم الأوامر
$help_text .= "\n<b>📊 إدارة متقدمة:</b>\n";
$help_text .= "/bot_rename - تعديل اسم بوت\n";
$help_text .= "/group_details - معلومات مجموعة\n";
$help_text .= "/bot_details - معلومات بوت\n";
$help_text .= "/account_details - معلومات حساب\n";
```

---

## 📝 أمثلة الاستخدام

### 1. تعديل اسم بوت:

```
/bot_rename test1 new_test
```

**النتيجة:**
```
✅ تم تعديل اسم البوت بنجاح!

الاسم القديم: test1
الاسم الجديد: new_test

⚠️ ملاحظة: سيتم تحديث:
• الحدود الخاصة بالبوت
• العدادات المرتبطة
• الحظر المرتبط
تلقائياً (Foreign Key Cascade)
```

---

### 2. استعلام عن مجموعة:

```
/group_details default
```

**النتيجة:**
```
📂 معلومات المجموعة: default ⭐

🔹 الحالة: ✅ نشطة
🔹 الوصف: المجموعة الافتراضية

🤖 البوتات المرتبطة: (3)
1. ▶️ test1 (ID: 27)
2. ▶️ test2 (ID: 28)
3. ▶️ test3 (ID: 29)

👤 الحسابات المرتبطة: (5)
1. ✅ steamuser1 (ID: 42)
2. ✅ steamuser2 (ID: 43)
3. ✅ steamuser3 (ID: 44)
4. ✅ steamuser4 (ID: 45)
5. ✅ steamuser5 (ID: 46)
```

---

### 3. استعلام عن بوت:

```
/bot_details test1
```

**النتيجة:**
```
🤖 معلومات البوت: test1

🔹 ID: 27
🔹 الحالة: ▶️ نشط
🔹 الحد الأقصى للمستخدمين: 100

📂 المجموعات المرتبطة: (2)
1. ✅ default (ID: 1)
2. ✅ vip (ID: 2)

👤 الحسابات المرتبطة: (7)

   📁 default:
   1. ✅ steamuser1 (ID: 42)
   2. ✅ steamuser2 (ID: 43)

   📁 vip:
   3. ✅ vipuser1 (ID: 50)
   4. ✅ vipuser2 (ID: 51)

⚙️ الحدود الخاصة بالبوت:
   • الوضع: يومي
   • الحد اليومي: 10 كود
```

---

### 4. استعلام عن حساب:

```
/account_details steamuser1
```

**النتيجة:**
```
👤 معلومات الحساب: steamuser1

🔹 ID: 42
🔹 الحالة: ✅ نشط
🔹 كلمة المرور: Pass123
🔹 Steam Guard: ABC123

📂 المجموعة المرتبطة:
   ✅ default (ID: 1)

🤖 البوتات المرتبطة: (3)
   1. ▶️ test1 (ID: 27)
   2. ▶️ test2 (ID: 28)
   3. ▶️ test3 (ID: 29)

⚙️ الحدود الخاصة:
   ✅ حدود خاصة بالحساب:
   • الوضع: أسبوعي
   • الحد اليومي: 5 كود
   • السقف: 20 كود
   • مدة الحظر: 7 يوم
```

---

## 🔍 مقارنة: قبل وبعد

### قبل (groups_list):
```
📂 قائمة المجموعات:

✅ default
   3 بوت | 1 حساب

✅ vip
   2 بوت | 5 حساب
```

### بعد (group_details):
```
📂 معلومات المجموعة: default ⭐

🔹 الحالة: ✅ نشطة
🔹 الوصف: المجموعة الافتراضية

🤖 البوتات المرتبطة: (3)
1. ▶️ test1 (ID: 27)
2. ▶️ test2 (ID: 28)
3. ⏸️ test3 (ID: 29)

👤 الحسابات المرتبطة: (1)
1. ✅ steamuser1 (ID: 42)
```

**الفرق:**
- ✅ أسماء مفصلة بدلاً من أرقام فقط
- ✅ حالة كل بوت (نشط/متوقف)
- ✅ حالة كل حساب (نشط/معطل)
- ✅ IDs للمرجع
- ✅ ترقيم الأسماء

---

## ✅ التحقق من التطبيق

بعد التطبيق، اختبر:

```bash
# 1. تعديل اسم بوت
/bot_rename test1 test_renamed

# 2. استعلام المجموعات
/group_details default

# 3. استعلام البوتات
/bot_details test_renamed

# 4. استعلام الحسابات
/account_details steamuser1
/account_details 42
```

---

## 📦 الملفات

| الملف | الغرض |
|-------|-------|
| `NEW_COMMANDS.php` | كود الأوامر الجديدة (للدمج) |
| `UPDATE_COMMANDS_MESSAGES.sql` | قوالب الرسائل (للتنفيذ) |
| `INTEGRATION_INSTRUCTIONS.md` | دليل التطبيق (هذا الملف) |

---

## 💡 ملاحظات مهمة

1. **Foreign Key Cascade:**
   - عند تعديل اسم البوت، يتم تحديث:
     - `limits_bot.bot_label`
     - `limit_counters.bot_label`
     - `limit_bans.bot_label`
   - تلقائياً بفضل `ON UPDATE CASCADE`

2. **البحث بالاسم أو ID:**
   - `/account_details` يدعم كلاهما
   - `/group_details` بالاسم فقط
   - `/bot_details` بالاسم فقط

3. **التوافقية:**
   - الأوامر القديمة تعمل كما هي
   - الأوامر الجديدة إضافية فقط

---

## 🎯 الخلاصة

✅ 4 أوامر جديدة  
✅ معلومات تفصيلية  
✅ أسماء وأرقام منظمة  
✅ سهولة في التتبع والإدارة

---

*آخر تحديث: 2025-10-25 17:25 UTC+03*
