# 📝 سجل التغييرات (Changelog)

جميع التغييرات البارزة في هذا المشروع موثقة في هذا الملف.

---

## [1.2.0] - 2025-10-25

### ✨ إضافات جديدة

#### أوامر جديدة في control_bot.php
- **`/group_details <group_name>`** - عرض تفاصيل المجموعة الكاملة
  - البوتات المرتبطة (عدد + قائمة)
  - الحسابات المرتبطة (عدد + قائمة)
  - الحالة (نشطة/معطلة)
  - الوصف
  - علامة المجموعة الافتراضية

- **`/bot_details <bot_label>`** - عرض تفاصيل البوت الكاملة
  - معلومات أساسية (ID, الحالة, الحد الأقصى للمستخدمين)
  - المجموعات المرتبطة (عدد + قائمة مع الحالة)
  - الحسابات المرتبطة (مجمعة حسب المجموعة)
  - الحدود الخاصة بالبوت (إن وجدت)

- **`/account_details <account_name|ID>`** - عرض تفاصيل الحساب
  - معلومات أساسية (ID, الحالة)
  - Steam Guard Secret (أول 10 أحرف)
  - المجموعة المرتبطة
  - البوتات المرتبطة (عبر المجموعة)
  - الحدود الخاصة بالحساب (إن وجدت)
  - يدعم البحث بالاسم أو ID

- **`/bot_rename <old_label> <new_label>`** - تعديل اسم البوت
  - تحديث تلقائي للـ Foreign Keys
  - رسائل تأكيد وخطأ واضحة
  - التحقق من عدم وجود الاسم الجديد

#### ملفات جديدة
- `PROJECT_ANALYSIS.md` - تحليل شامل للمشروع
- `PROJECT_ORGANIZATION.md` - دليل تنظيم المشروع
- `CHANGELOG.md` - سجل التغييرات
- `test_commands.php` - ملف اختبار `/group_details`
- `test_account_details.php` - ملف اختبار `/account_details`
- `DEBUG_INSTRUCTIONS.txt` - تعليمات التشخيص
- `FIX_SUMMARY.txt` - ملخص الإصلاحات
- `FIX_ACCOUNT_DETAILS.txt` - إصلاح `/account_details`

#### ملفات SQL
- `UPDATE_HELP_TEXTS.sql` - تحديث نصوص المساعدة
- `CLEANUP_UNUSED_KEYS.sql` - تنظيف المفاتيح غير المستخدمة

### 🔧 إصلاحات

#### إصلاحات حرجة
1. **تصحيح اسم العمود في steam_accounts**
   - المشكلة: استخدام `is_active` في الاستعلامات
   - الحل: تصحيح إلى `active` في جميع الملفات
   - الملفات المتأثرة:
     - `control_bot.php` (5 إصلاحات)
     - `test_commands.php` (2 إصلاحات)
   - الخطأ الأصلي: `Unknown column 'sa.is_active'`

2. **HTML Parsing Error**
   - المشكلة: Telegram يرفض الرسائل بسبب أحرف HTML خاصة
   - الحل: إضافة `htmlspecialchars()` لجميع البيانات المتغيرة
   - التطبيق:
     - أسماء المجموعات
     - أسماء البوتات
     - أسماء الحسابات
     - الأوصاف
     - Steam Guard Secret
     - جميع البيانات من قاعدة البيانات

3. **معالجة shared_secret الفارغ**
   - المشكلة: عرض فارغ إذا كان الحساب بدون Steam Guard
   - الحل: معالجة الحالة الفارغة وعرض "غير متوفر"
   - التحسين: عرض أول 10 أحرف فقط للأمان

4. **معالجة الأخطاء**
   - تحديث `lib/telegram.php`:
     - إرجاع نتيجة API بدلاً من void
     - تسجيل الأخطاء في error_log
     - عرض طول الرسالة عند الخطأ
   - إضافة معالجة خطأ في الأوامر الثلاثة:
     - إرسال رسالة خطأ واضحة للمستخدم
     - عرض سبب الفشل من Telegram API
     - عرض طول الرسالة

#### تحسينات الأمان
- عدم عرض `shared_secret` كاملاً (أول 10 أحرف فقط)
- `htmlspecialchars` على جميع المخرجات
- معالجة البيانات الفارغة/null بشكل آمن

### 📚 تحسينات التوثيق

#### ملفات توثيق جديدة
- **PROJECT_ANALYSIS.md**
  - نظرة عامة شاملة
  - معمارية النظام
  - هيكل الملفات
  - قاعدة البيانات (23 جدول)
  - الميزات الرئيسية
  - الإحصائيات
  - متطلبات التشغيل
  - الحالة الحالية

- **PROJECT_ORGANIZATION.md**
  - الهيكل المقترح
  - الملفات للحذف/النقل/الاحتفاظ
  - خطوات التنظيم (6 مراحل)
  - إعداد الإنتاج
  - قائمة التحقق
  - تحذيرات مهمة

#### تحديثات README.md
- إضافة الأوامر الجديدة
- تحديث قائمة الميزات
- إضافة أمثلة الاستخدام

#### تحديثات help_content.php
- إضافة وصف الأوامر الجديدة في `/help`
- تحديث help_part1 و help_part3 و help_part4

### 🔄 تغييرات في البنية

#### lib/telegram.php
```php
// قبل
function tg_send(...): void

// بعد
function tg_send(...): array
// + error logging
// + return result
```

#### control_bot.php
- إضافة 4 أوامر جديدة (430+ سطر)
- إصلاح 5 استعلامات SQL
- إضافة معالجة خطأ شاملة
- تحسين رسائل المساعدة

### 📊 الإحصائيات

#### التغييرات في الكود
- **control_bot.php**: +450 سطر
- **lib/telegram.php**: +15 سطر
- **ملفات جديدة**: 11 ملف
- **ملفات SQL**: 3 ملفات

#### الأوامر
- **إجمالي الأوامر**: 52+ أمر
- **أوامر جديدة**: 4 أوامر
- **أوامر محسّنة**: /help

---

## [1.1.0] - 2025-10-24

### ✨ إضافات
- نظام المجموعات (Bot Isolation)
- جدول `account_groups`
- جدول `group_accounts`
- جدول `bot_groups`
- ربط البوتات بالمجموعات
- ربط الحسابات بالمجموعات

### 🔧 إصلاحات
- تحسين نظام الحدود
- إصلاحات الأداء

---

## [1.0.0] - 2025-08-27

### ✨ الإصدار الأول
- بوت التحكم الرئيسي
- بوت التوزيع للمستخدمين
- نظام الحدود الأساسي
- نظام القسائم
- إدارة البوتات
- إدارة المستخدمين
- إدارة الحسابات
- Steam Guard Generator
- نظام البث

---

## 📋 Legend

- ✨ **إضافات جديدة** - New features
- 🔧 **إصلاحات** - Bug fixes
- 📚 **توثيق** - Documentation
- 🔄 **تغييرات** - Changes
- ⚠️ **تحذيرات** - Warnings
- 🗑️ **حذف** - Removed
- 📊 **إحصائيات** - Statistics

---

## 🔗 الإصدارات

- **v1.2.0** - الأوامر الجديدة + الإصلاحات الشاملة (حالي)
- **v1.1.0** - نظام المجموعات
- **v1.0.0** - الإصدار الأول

---

## 📞 للمزيد من المعلومات

راجع:
- `README.md` - الوثائق الرئيسية
- `PROJECT_ANALYSIS.md` - تحليل المشروع
- `PROJECT_ORGANIZATION.md` - تنظيم المشروع
- `INTEGRATION_INSTRUCTIONS.md` - تعليمات الدمج

---

**آخر تحديث:** 25 أكتوبر 2025  
**الحالة:** ✅ Production Ready
