# دليل الترحيل - Migration Guide

## 📋 المحتويات

1. [نظرة عامة](#نظرة-عامة)
2. [الملفات المتوفرة](#الملفات-المتوفرة)
3. [المتطلبات](#المتطلبات)
4. [الاستخدام](#الاستخدام)
5. [المتغيرات البيئية](#المتغيرات-البيئية)
6. [أمثلة الاستخدام](#أمثلة-الاستخدام)
7. [استكشاف الأخطاء](#استكشاف-الأخطاء)

---

## 🎯 نظرة عامة

هذه المجموعة من الأدوات تمكنك من ترحيل البيانات التشغيلية من قاعدة `supehgku_Packagemaker` (القديمة) إلى `supehgku_fixed_v2` (الجديدة) بشكل آمن ومضمون.

### ✅ ما يتم ترحيله:
- **sub_bots** (26 بوت)
- **steam_accounts** (102 حساب)
- **allowed_users** (358 مستخدم)
- **steam_requests** (3411 طلب)
- **control_sessions** (25 جلسة - اختياري)

### ❌ ما لا يتم ترحيله:
- جداول **limits_*** (نظام الحدود الجديد)
- **message_templates** (نبقي القوالب الجديدة)
- أعمدة **daily_attempts** (معطلة في النظام الجديد)

---

## 📁 الملفات المتوفرة

| الملف | الوصف |
|------|-------|
| `migration_plan.txt` | خطة الترحيل الكاملة مع التحليل التفصيلي |
| `migrate_core_no_templates.sql` | سكريبت SQL للترحيل اليدوي |
| `migrate_core_no_templates.php` | سكريبت PHP ذكي (موصى به) |
| `README_MIGRATION.md` | هذا الملف |

---

## ⚙️ المتطلبات

### للسكريبت SQL:
- MySQL/MariaDB Client
- صلاحية الوصول إلى كلا القاعدتين

### للسكريبت PHP:
- PHP 7.4+ مع PDO extension
- صلاحية تشغيل السكريبتات من command line
- صلاحية الكتابة في مجلد السكريبت (للـ logs والحالة)

---

## 🚀 الاستخدام

### الطريقة 1: سكريبت PHP (موصى به)

#### خطوة 1: اختبار (Dry-Run)
```bash
php migrate_core_no_templates.php --dry-run
```
هذا الأمر يختبر العملية **دون تنفيذ أي تغييرات**. سيعرض لك:
- عدد السجلات التي سيتم ترحيلها
- الاستعلامات التي ستُنفذ
- الوقت المتوقع

#### خطوة 2: الترحيل الفعلي
```bash
php migrate_core_no_templates.php
```

#### خطوة 3 (اختياري): مع جلسات التحكم
```bash
php migrate_core_no_templates.php --with-sessions
```

### الطريقة 2: سكريبت SQL

```bash
mysql -u username -p < migrate_core_no_templates.sql
```

**ملاحظة:** السكريبت SQL لا يدعم Resume (الاستئناف) وقد يستغرق وقتاً أطول.

---

## 🔧 المتغيرات البيئية

يمكنك تخصيص الاتصال بقاعدة البيانات عبر المتغيرات البيئية:

### Linux/Mac:
```bash
export DB_HOST="localhost"
export DB_USER="your_username"
export DB_PASS="your_password"
export DB_SOURCE="supehgku_Packagemaker"
export DB_TARGET="supehgku_fixed_v2"

php migrate_core_no_templates.php
```

### Windows (PowerShell):
```powershell
$env:DB_HOST="localhost"
$env:DB_USER="your_username"
$env:DB_PASS="your_password"
$env:DB_SOURCE="supehgku_Packagemaker"
$env:DB_TARGET="supehgku_fixed_v2"

php migrate_core_no_templates.php
```

### Windows (CMD):
```cmd
set DB_HOST=localhost
set DB_USER=your_username
set DB_PASS=your_password
set DB_SOURCE=supehgku_Packagemaker
set DB_TARGET=supehgku_fixed_v2

php migrate_core_no_templates.php
```

### القيم الافتراضية:
| المتغير | القيمة الافتراضية |
|---------|-------------------|
| DB_HOST | localhost |
| DB_USER | root |
| DB_PASS | (فارغ) |
| DB_SOURCE | supehgku_Packagemaker |
| DB_TARGET | supehgku_fixed_v2 |

---

## 💡 أمثلة الاستخدام

### مثال 1: اختبار سريع
```bash
php migrate_core_no_templates.php --dry-run
```
**النتيجة:**
```
[DRY-RUN] Would migrate 26 sub_bots records
[DRY-RUN] Would migrate 102 steam_accounts records
[DRY-RUN] Would migrate 358 allowed_users records
[DRY-RUN] Would migrate 3411 steam_requests records
```

### مثال 2: ترحيل كامل بدون جلسات
```bash
php migrate_core_no_templates.php
```

### مثال 3: ترحيل مع جلسات التحكم
```bash
php migrate_core_no_templates.php --with-sessions
```

### مثال 4: استئناف بعد فشل
إذا فشل الترحيل في منتصف العملية، ببساطة أعد تشغيل نفس الأمر:
```bash
php migrate_core_no_templates.php
```
السكريبت سيستأنف من آخر نقطة نجاح تلقائياً!

### مثال 5: استخدام مع اتصال مخصص
```bash
export DB_USER="admin"
export DB_PASS="strong_password_123"
php migrate_core_no_templates.php
```

---

## 🔍 الملفات المُنشأة أثناء التنفيذ

### `.migrate_state.json`
ملف حالة الترحيل - يُستخدم للاستئناف:
```json
{
    "sub_bots_last_id": 26,
    "steam_accounts_last_id": 102,
    "allowed_users_last_id": 358,
    "steam_requests_last_id": 3411,
    "control_sessions_last_id": 0
}
```
**يُحذف تلقائياً** عند اكتمال الترحيل بنجاح.

### `migrate_execution.log`
سجل تفصيلي لكل العمليات:
```
[2025-10-26 01:00:00] [INFO] Migration Script Started
[2025-10-26 01:00:01] [INFO] Connected to both databases
[2025-10-26 01:00:02] [INFO] === Starting sub_bots migration ===
[2025-10-26 01:00:03] [SUCCESS] ✅ sub_bots migration completed: 26 records
...
```

---

## 🛡️ الأمان والضمانات

### ✅ Idempotent
يمكنك تشغيل السكريبت عدة مرات دون تكرار البيانات. يستخدم `ON DUPLICATE KEY UPDATE`.

### ✅ Resume Capability
في حالة الفشل، يحفظ الموقع ويستأنف من آخر نقطة نجاح.

### ✅ Transactional
كل دفعة (batch) في معاملة منفصلة. إذا فشلت معاملة، يتم ROLLBACK تلقائياً.

### ✅ Foreign Key Safe
يتعامل مع Foreign Keys بشكل صحيح (تعطيل مؤقت → ترحيل → تفعيل).

---

## 📊 التحقق بعد الترحيل

بعد الترحيل الناجح، تحقق من البيانات:

```sql
-- 1. عدد السجلات
SELECT 'sub_bots' as tbl, COUNT(*) FROM supehgku_fixed_v2.sub_bots
UNION ALL
SELECT 'steam_accounts', COUNT(*) FROM supehgku_fixed_v2.steam_accounts
UNION ALL
SELECT 'allowed_users', COUNT(*) FROM supehgku_fixed_v2.allowed_users
UNION ALL
SELECT 'steam_requests', COUNT(*) FROM supehgku_fixed_v2.steam_requests;

-- 2. التحقق من المجموعات الافتراضية (Triggers)
SELECT COUNT(*) as bots_in_default_group 
FROM supehgku_fixed_v2.bot_groups bg
JOIN supehgku_fixed_v2.account_groups ag ON bg.group_id = ag.id
WHERE ag.is_default = 1;
-- يجب أن يساوي عدد البوتات (26)

-- 3. التحقق من Foreign Keys
SELECT COUNT(*) as orphaned_users
FROM supehgku_fixed_v2.allowed_users au
LEFT JOIN supehgku_fixed_v2.sub_bots sb ON au.bot_token = sb.bot_token
WHERE sb.bot_token IS NULL;
-- يجب أن يكون 0
```

---

## ⚠️ استكشاف الأخطاء

### خطأ: "Connection refused"
**السبب:** لا يمكن الاتصال بقاعدة البيانات.
**الحل:**
1. تحقق من أن MySQL يعمل: `sudo service mysql status`
2. تحقق من اسم المستخدم وكلمة المرور
3. تحقق من `DB_HOST` (استخدم `127.0.0.1` بدلاً من `localhost` إذا لزم الأمر)

### خطأ: "Table doesn't exist"
**السبب:** اسم قاعدة البيانات خاطئ.
**الحل:**
```sql
SHOW DATABASES;
```
تأكد من أن القاعدتين موجودتان بالأسماء الصحيحة.

### خطأ: "Duplicate entry"
**السبب:** البيانات موجودة بالفعل (هذا طبيعي).
**الحل:** السكريبت يستخدم `ON DUPLICATE KEY UPDATE` - لا مشكلة.

### خطأ: "Foreign key constraint fails"
**السبب:** خلل في ترتيب الترحيل.
**الحل:**
1. احذف `.migrate_state.json`
2. أعد التشغيل من البداية

### السكريبت توقف في منتصف steam_requests
**السبب:** timeout أو مشكلة في الاتصال.
**الحل:**
```bash
# ببساطة أعد التشغيل - سيستأنف تلقائياً
php migrate_core_no_templates.php
```

### أريد إعادة الترحيل من الصفر
**الحل:**
```bash
# احذف ملف الحالة
rm .migrate_state.json

# أعد التشغيل
php migrate_core_no_templates.php
```

---

## 🔄 خطة التراجع (Rollback)

إذا احتجت للتراجع الكامل:

```sql
-- تحذير: هذا سيحذف جميع البيانات المُرحّلة!

USE supehgku_fixed_v2;
SET FOREIGN_KEY_CHECKS=0;

TRUNCATE TABLE steam_requests;
TRUNCATE TABLE allowed_users;
TRUNCATE TABLE control_sessions;

-- احذف فقط الحسابات المُرحّلة
DELETE FROM steam_accounts WHERE id IN (
  SELECT id FROM supehgku_Packagemaker.steam_accounts
);

-- احذف فقط البوتات المُرحّلة
DELETE FROM sub_bots WHERE id IN (
  SELECT id FROM supehgku_Packagemaker.sub_bots
);

SET FOREIGN_KEY_CHECKS=1;
```

---

## 📝 خطوات ما بعد الترحيل

### 1. ضبط نظام الحدود
```sql
USE supehgku_fixed_v2;

-- مثال: حد أسبوعي (2 يومياً، 6 أسبوعياً، حظر 7 أيام)
UPDATE limits_global 
SET mode='weekly', 
    per_day=2, 
    weekly_cap=6, 
    ban_days=7 
WHERE id=1;
```

### 2. اختبار بوت واحد
- سجل دخول لبوت واحد
- اطلب كود من حساب
- تحقق من أن الكود يصل
- تحقق من أن نظام الحدود يعمل

### 3. مراقبة Logs
```sql
SELECT * FROM supehgku_fixed_v2.system_logs 
ORDER BY created_at DESC 
LIMIT 50;
```

### 4. اختبار المجموعات
```sql
-- تحقق من أن البوتات في المجموعة الافتراضية
SELECT sb.label, ag.group_name
FROM sub_bots sb
JOIN bot_groups bg ON sb.id = bg.bot_id
JOIN account_groups ag ON bg.group_id = ag.id;
```

---

## 📞 الدعم

إذا واجهت مشاكل:
1. راجع `migrate_execution.log` للتفاصيل
2. راجع خطة الترحيل `migration_plan.txt`
3. تأكد من النسخة الاحتياطية قبل أي rollback

---

## ✅ Checklist قبل الترحيل

- [ ] أخذ نسخة احتياطية من `supehgku_fixed_v2`
- [ ] اختبار بـ `--dry-run`
- [ ] التأكد من أن النظام غير مستخدم بكثافة
- [ ] مراجعة خطة الترحيل
- [ ] تجهيز خطة التراجع

## ✅ Checklist بعد الترحيل

- [ ] التحقق من عدد السجلات (Row Count)
- [ ] التحقق من Foreign Keys
- [ ] التحقق من Triggers (المجموعات الافتراضية)
- [ ] ضبط `limits_global`
- [ ] اختبار بوت واحد
- [ ] مراقبة `system_logs`
- [ ] حذف `.migrate_state.json` (يُحذف تلقائياً)

---

**نهاية الدليل** - بالتوفيق! 🚀
